/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.RandSync;
import baltorogames.project_gameplay.CGBallShooter;
import baltorogames.project_gameplay.CGBoard;
import baltorogames.project_gameplay.CGEngine;
import java.util.Vector;

public class CGBallCannon {
    private int[] ballColors;
    private int currentBallColorIndex;
    public static final float maxCannonAngle = 75.0f;
    private int[] boardBallColors = new int[7];
    private int[] tmpBallColors = new int[7];
    private int tmpBallColorsSize = 0;
    public float m_fPosX;
    public float m_fPosY;
    public char m_nColor;
    public char m_nNextColor;
    public char m_bReady = '\u0001';
    public int m_nReadyTimer;
    public Vector m_arrShooters = new Vector();
    public float m_fCurrentAngle = 0.0f;
    public float m_fCurrentBallDY = -26.0f;
    public float m_fCurrentBallPosX;
    public float m_fCurrentBallPosY;
    public float m_fNextBallDY = 34.0f;
    public float m_fNextBallPosX;
    public float m_fNextBallPosY;

    public void setBallColors(int[] colors) {
        this.currentBallColorIndex = 0;
        this.ballColors = new int[colors.length * 2];
        for (int i = 0; i < colors.length; ++i) {
            this.ballColors[i * 2] = colors[i];
            this.ballColors[i * 2 + 1] = colors[i];
        }
        this.getNextBallColor();
        do {
            this.m_nNextColor = (char)this.getNextBallColor();
        } while (CGEngine.m_Board != null && !CGEngine.m_Board.checkColorExists(this.m_nNextColor));
        this.m_nColor = this.m_nNextColor;
        do {
            this.m_nNextColor = (char)this.getNextBallColor();
        } while (CGEngine.m_Board != null && !CGEngine.m_Board.checkColorExists(this.m_nNextColor));
        System.out.println("AAA: Color=" + this.m_nColor + "  NextColor=" + this.m_nNextColor);
    }

    public CGBallCannon() {
        this.m_nColor = (char)100;
        this.m_nNextColor = (char)100;
    }

    public int getNextBallColor() {
        int i;
        int ballColor = 0;
        ballColor = 1 + RandSync.nextInt(6);
        if (CGEngine.m_Board == null) {
            ballColor = 1 + RandSync.nextInt(6);
            return ballColor;
        }
        for (i = 0; i < 7; ++i) {
            this.boardBallColors[i] = 0;
        }
        for (int x = 0; x < CGEngine.m_Board.m_nGridSizeX; ++x) {
            for (int y = 0; y < CGEngine.m_Board.m_nGridSizeY; ++y) {
                if (CGEngine.m_Board.m_arrGrid[x][y] <= '\u0000' || CGEngine.m_Board.m_arrGrid[x][y] > '\u0006') continue;
                this.boardBallColors[CGEngine.m_Board.m_arrGrid[x][y]] = 1;
            }
        }
        this.tmpBallColorsSize = 0;
        for (i = 0; i < 7; ++i) {
            if (this.boardBallColors[i] <= 0) continue;
            this.tmpBallColors[this.tmpBallColorsSize] = i;
            ++this.tmpBallColorsSize;
        }
        ballColor = this.tmpBallColorsSize > 0 ? this.tmpBallColors[RandSync.nextInt(this.tmpBallColorsSize)] : 1 + RandSync.nextInt(6);
        return ballColor;
    }

    public void Destroy() {
    }

    public void PrepareNew() {
        this.UpdateColor();
    }

    public void ActualizeSpaceShip() {
        if (this.m_fCurrentAngle < 0.0f && this.m_fCurrentAngle < -75.0f) {
            this.m_fCurrentAngle = -75.0f;
        } else if (this.m_fCurrentAngle > 75.0f) {
            this.m_fCurrentAngle = 75.0f;
        }
        float fSin = (float)Math.sin(this.m_fCurrentAngle * 3.1415f / 180.0f);
        float fCos = (float)Math.cos(this.m_fCurrentAngle * 3.1415f / 180.0f);
        this.m_fCurrentBallDY = -26.0f * CGBoard.eBallRadius / 22.0f;
        this.m_fNextBallDY = 34.0f * CGBoard.eBallRadius / 22.0f;
        this.m_fCurrentBallPosX = 0.0f * fCos - this.m_fCurrentBallDY * fSin;
        this.m_fCurrentBallPosY = 0.0f * fSin + this.m_fCurrentBallDY * fCos;
        this.m_fCurrentBallPosX += this.m_fPosX;
        this.m_fCurrentBallPosY += this.m_fPosY;
        this.m_fNextBallPosX = 0.0f * fCos - this.m_fNextBallDY * fSin;
        this.m_fNextBallPosY = 0.0f * fSin + this.m_fNextBallDY * fCos;
        this.m_fNextBallPosX += this.m_fPosX;
        this.m_fNextBallPosY += this.m_fPosY;
    }

    public void Update(int nDeltaTimeInMs) {
        while (CGEngine.m_Board != null && !CGEngine.m_Board.checkColorExists(this.m_nNextColor) && CGEngine.m_Board.BallsSize() != 0 && CGEngine.m_Board.m_nTimeToCheck <= 0) {
            this.m_nNextColor = (char)this.getNextBallColor();
        }
        while (CGEngine.m_Board != null && !CGEngine.m_Board.checkColorExists(this.m_nColor) && CGEngine.m_Board.BallsSize() != 0 && CGEngine.m_Board.m_nTimeToCheck <= 0) {
            this.m_nColor = (char)this.getNextBallColor();
        }
        if (CGEngine.m_bGameOver) {
            for (int i = this.m_arrShooters.size() - 1; i >= 0; --i) {
                this.m_arrShooters.removeElementAt(i);
            }
            return;
        }
        if (this.m_bReady == '\u0000') {
            this.m_nReadyTimer += nDeltaTimeInMs;
            if (this.m_nReadyTimer > 500) {
                this.m_bReady = '\u0001';
                this.m_nReadyTimer = 0;
            }
        }
        for (int i = this.m_arrShooters.size() - 1; i >= 0; --i) {
            ((CGBallShooter)this.m_arrShooters.elementAt(i)).Update(nDeltaTimeInMs);
            if (((CGBallShooter)this.m_arrShooters.elementAt(i)).IsDestroyed() <= 'd') continue;
            this.m_arrShooters.removeElementAt(i);
        }
    }

    public void SetTarget(float x, float y) {
        if (CGEngine.m_bGameOver || CGEngine.m_bPause) {
            return;
        }
        if (this.m_bReady == '\u0000') {
            return;
        }
        if (CGEngine.AngleFromVector(x - this.m_fPosX, y - this.m_fPosY) > -75.0f && CGEngine.AngleFromVector(x - this.m_fPosX, y - this.m_fPosY) < 75.0f) {
            this.m_fCurrentAngle = CGEngine.AngleFromVector(x - this.m_fPosX, y - this.m_fPosY);
        }
        float fSin = (float)Math.sin(this.m_fCurrentAngle * 3.1415f / 180.0f);
        float fCos = (float)Math.cos(this.m_fCurrentAngle * 3.1415f / 180.0f);
        this.m_fCurrentBallPosX = 0.0f * fCos - this.m_fCurrentBallDY * fSin;
        this.m_fCurrentBallPosY = 0.0f * fSin + this.m_fCurrentBallDY * fCos;
        this.m_fCurrentBallPosX += this.m_fPosX;
        this.m_fCurrentBallPosY += this.m_fPosY;
        this.m_fNextBallPosX = 0.0f * fCos - this.m_fNextBallDY * fSin;
        this.m_fNextBallPosY = 0.0f * fSin + this.m_fNextBallDY * fCos;
        this.m_fNextBallPosX += this.m_fPosX;
        this.m_fNextBallPosY += this.m_fPosY;
        CGBallShooter pBS = new CGBallShooter();
        pBS.m_fBallX = this.m_fCurrentBallPosX;
        pBS.m_fBallY = this.m_fCurrentBallPosY;
        pBS.SetTarget(x, y);
        pBS.m_nColor = this.m_nColor;
        pBS.m_fSpeed = CGBallShooter.eDefaultSpeed;
        this.m_arrShooters.addElement(pBS);
        this.PrepareNew();
        this.m_bReady = '\u0000';
        this.m_nReadyTimer = 1;
    }

    public void SetPosition(float x, float y) {
        this.m_fPosX = x;
        this.m_fPosY = y;
        this.ActualizeSpaceShip();
    }

    public void SetReady(char b) {
        this.m_bReady = b;
    }

    public char GetReady() {
        return this.m_bReady;
    }

    public void UpdateColor() {
        this.m_bReady = '\u0001';
        this.m_nReadyTimer = 0;
        do {
            this.m_nColor = (char)this.getNextBallColor();
        } while (CGEngine.m_Board != null && !CGEngine.m_Board.checkColorExists(this.m_nColor));
        this.m_nColor = this.m_nNextColor;
        do {
            this.m_nNextColor = (char)this.getNextBallColor();
        } while (CGEngine.m_Board != null && !CGEngine.m_Board.checkColorExists(this.m_nNextColor));
        System.out.println("Color=" + this.m_nColor + "  NextColor=" + this.m_nNextColor);
    }
}

