/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.VectorF2;
import baltorogames.project_gameplay.CGAchievements;
import baltorogames.project_gameplay.CGBallCannon;
import baltorogames.project_gameplay.CGBoard;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGHit;
import baltorogames.project_gameplay.CGLevelStats;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gameplay.IBoardListener;
import baltorogames.project_gameplay.LevelScenario;
import baltorogames.project_gui.LevelWinScreen;

public class BoardListener
implements IBoardListener {
    private static final int TIME_FOR_SEPARATING_TIME_BALL = 4000;
    private static final int SCORE_FOR_SINGLE_BALL = 10;
    public static final int MAXIMUM_ROWS_ALLOWED = 10;
    private static final int SCORE_FOR_SINGLE_BALL_SEPARATED = 10;
    private static final int MAX_COMBO_LEVEL = 5;
    private static final float REFIL_FOR_SINGLE_BALL_SURVIVAL = 2.0f;
    private int comboLevel;
    private int lostBalls = 0;

    public void Event_BallSeparated(CGBoard board, int x, int y, int type) {
        System.out.println("Event_BallSeparated:" + x + "," + y + "," + type);
        if (type == 8) {
            System.out.println("Extra time added (ms):4000");
            CGLevelStats.m_nTimeInMs += 4000;
        } else if (type == 12) {
            ++CGLevelStats.m_nItemsGathered;
        } else {
            CGLevelStats.m_nScore += 10 * this.comboLevel;
        }
    }

    public void Event_BallDestroyed(CGBoard board, int x, int y, int type, boolean launchParticle) {
        System.out.println("Event_BallDestroyed:" + x + "," + y + "," + type);
        if (launchParticle) {
            board.GetRealPosition(x, y, VectorF2.g_Vec1);
            CGHit.NewHit(0, VectorF2.g_Vec1.x, VectorF2.g_Vec1.y, 800L);
        }
        CGLevelStats.m_nScore += 10 * (this.comboLevel + 1);
        if (CGEngine.m_nSurvivalLevel >= 0 && CGEngine.m_SurvivalTimeBar != null) {
            CGEngine.m_SurvivalTimeBar.AddValue(2.0f);
        }
    }

    public void Event_NewBallOnBoard(CGBoard board, int nGridX, int nGridY, int type) {
        System.out.println("Event_NewBallOnBoard: X=" + nGridX + " Y=" + nGridY + "type:" + type);
        ++CGLevelStats.m_nBallsUsed;
    }

    public void Event_HitBall(CGBoard board, int nGridX, int nGridY, int type) {
        block5: {
            block6: {
                block4: {
                    System.out.println("Event_HitBall: X=" + nGridX + " Y=" + nGridY + "type:" + type);
                    if (type != 7) break block4;
                    System.out.println("Bomb explosion at:" + nGridX + "," + nGridY);
                    board.m_arrGrid[nGridX][nGridY] = '\u0000';
                    for (int i = 0; i < 6; ++i) {
                        int x = board.GetNeighbourGridXFor(nGridX, nGridY, i);
                        int y = board.GetNeighbourGridYFor(nGridX, nGridY, i);
                        if (x < 0 || y < 0 || x >= board.m_nGridSizeX || y >= board.m_nGridSizeY) continue;
                        this.Event_BallDestroyed(board, x, y, board.m_arrGrid[x][y], false);
                        if (board.m_arrGrid[x][y] == '\u0007') {
                            this.Event_HitBall(board, x, y, 7);
                        }
                        board.m_arrGrid[x][y] = '\u0000';
                        board.GetRealPosition(x, y, VectorF2.g_Vec1);
                        CGHit.NewHit(1, VectorF2.g_Vec1.x, VectorF2.g_Vec1.y, 800L);
                    }
                    break block5;
                }
                if (type != 9) break block6;
                System.out.println("Color explosion at:" + nGridX + "," + nGridY);
                board.m_arrGrid[nGridX][nGridY] = CGEngine.m_BallCannon.m_nColor;
                for (int i = 0; i < 6; ++i) {
                    int x = board.GetNeighbourGridXFor(nGridX, nGridY, i);
                    int y = board.GetNeighbourGridYFor(nGridX, nGridY, i);
                    if (x < 0 || y < 0 || x >= board.m_nGridSizeX || y >= board.m_nGridSizeY || board.m_arrGrid[x][y] == '\u0000') continue;
                    board.GetRealPosition(x, y, VectorF2.g_Vec1);
                    CGHit.NewHit(3, VectorF2.g_Vec1.x, VectorF2.g_Vec1.y, 800L);
                    board.m_arrGrid[x][y] = CGEngine.m_BallCannon.m_nColor;
                }
                break block5;
            }
            if (type != 10) break block5;
            System.out.println("Fireexplosion at:" + nGridX + "," + nGridY);
            for (int i = 0; i < board.m_nGridSizeX; ++i) {
                if (board.m_arrGrid[i][nGridY] == '\u000b') continue;
                board.m_arrGrid[i][nGridY] = '\u0000';
                board.GetRealPosition(i, nGridY, VectorF2.g_Vec1);
                CGHit.NewHit(2, VectorF2.g_Vec1.x, VectorF2.g_Vec1.y, 800L);
            }
        }
    }

    public void Event_CleaningSeparatedBallsFinished(CGBoard board, int numSeparatedBalls) {
        System.out.println("Event_CleaningSeparatedBallsFinished:" + numSeparatedBalls);
    }

    public void Event_CleaningDestroyedBallsFinished(CGBoard board, int numSeparatedBalls) {
        System.out.println("Event_CleaningDestroyedBallsFinished:" + numSeparatedBalls);
        ++this.comboLevel;
        CGAchievements.AddCombo();
        if (this.comboLevel == 5) {
            CGAchievements.completeAchievement(2);
        } else if (this.comboLevel == 10) {
            CGAchievements.completeAchievement(3);
        }
        if (this.comboLevel > 5) {
            this.comboLevel = 5;
        }
        CGLevelStats.m_nActualCombo = this.comboLevel;
    }

    public void Event_ShootWithoutMatch3Hit(CGBoard board) {
        System.out.println("Event_ShootWithoutMatch3Hit");
        ++this.lostBalls;
        if (this.comboLevel > CGLevelStats.m_nMaxCombo) {
            CGLevelStats.m_nMaxCombo = this.comboLevel;
        }
        if (this.comboLevel > 0) {
            ++CGLevelStats.m_nCombos;
        }
        this.comboLevel = 0;
        CGLevelStats.m_nActualCombo = 0;
        ++CGLevelStats.m_nLostBalls;
    }

    public void Event_NewLineOfBallsGenerated(CGBoard board) {
        System.out.println("Event_NewLineOfBallsGenerated");
    }

    public void Event_NewBoardGenerated(CGBoard board) {
        System.out.println("Event_NewBoardGenerated");
        this.lostBalls = 0;
        CGLevelStats.m_nTimeInMs = board.m_LevelScenario.m_timeLimit * 1000;
        CGBallCannon cannon = CGEngine.GetBallCannon();
        cannon.setBallColors(board.m_LevelScenario.m_ballsFromFile);
    }

    public int checkGameIsOver(CGBoard board) {
        if (CGEngine.m_nSurvivalLevel >= 0) {
            if (board.getNumRows() > 10) {
                return -1;
            }
            return 0;
        }
        if (board.getNumRows() > 10) {
            return -1;
        }
        if (board.BallsSize() > 0) {
            return 0;
        }
        if (board.m_LevelScenario.m_nOffset >= 0) {
            return 0;
        }
        int nLevel = (CGEngine.m_nCurrentGalaxy - 1) * 15 + (CGEngine.m_nCurrentLevel - 1);
        int currentNumberOfStars = CGUserCareer.arrLevelStats[nLevel].m_nStars;
        int numStars = 1;
        if (this.areAllRequirementsCompleted(board)) {
            ++numStars;
        }
        if (this.didWeDeserveFor3Stars(board)) {
            ++numStars;
        }
        if (numStars > currentNumberOfStars) {
            CGUserCareer.arrLevelStats[nLevel].m_nStars = numStars;
        }
        if (this.lostBalls == 0) {
            // empty if block
        }
        CGAchievements.completeAchievement(1);
        if (currentNumberOfStars < 20 && numStars >= 20) {
            LevelWinScreen.showUnlockScreen = 1;
        }
        if (currentNumberOfStars < 65 && numStars >= 65) {
            LevelWinScreen.showUnlockScreen = 2;
        }
        return 1;
    }

    boolean didWeDeserveFor3Stars(CGBoard board) {
        LevelScenario ls = board.m_LevelScenario;
        if (ls.m_threeStarsItemLimit > 0 && CGLevelStats.m_nItemsGathered < ls.m_threeStarsItemLimit) {
            return false;
        }
        if (ls.m_threeStarsScoreLimit > 0 && CGLevelStats.m_nScore < ls.m_threeStarsScoreLimit) {
            return false;
        }
        if (ls.m_threeStarsTimeLimit > 0 && ls.m_timeLimit < ls.m_threeStarsTimeLimit) {
            return false;
        }
        return ls.m_threeStarsBallLimit <= 0 || CGLevelStats.m_nBallsUsed < ls.m_threeStarsBallLimit;
    }

    boolean areAllRequirementsCompleted(CGBoard board) {
        LevelScenario ls = board.m_LevelScenario;
        if (ls.m_itemLimit > 0 && CGLevelStats.m_nItemsGathered < ls.m_itemLimit) {
            return false;
        }
        if (ls.m_scoreLimit > 0 && CGLevelStats.m_nScore < ls.m_scoreLimit) {
            return false;
        }
        if (ls.m_timeLimit > 0 && ls.m_timeLimit <= 0) {
            return false;
        }
        return ls.m_ballLimit <= 0 || CGLevelStats.m_nBallsUsed < ls.m_ballLimit;
    }
}

