/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGSoundSystem;
import baltorogames.system.Application;
import baltorogames.system.Options;

public class LoadingScreen
extends UIScreen {
    private static final float SPLASH_TIME_INTERVAL = 4.0f;
    CGTexture image = TextureManager.AddTexture("/menu/splash.png");
    float time = 0.0f;
    int counterDraw = 0;

    public void drawWindowBackground() {
    }

    public void drawWindowForeground() {
    }

    public void draw() {
        if (this.image != null) {
            Graphic2D.SetColor(0);
            Graphic2D.FillRect(0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight);
            Graphic2D.DrawImage(this.image, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 2, 3);
        }
        int fontHeight = ApplicationData.defaultFont.getFontHeight();
        Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_LOADING"), this.width >> 1, ApplicationData.screenHeight, 33, 0);
        if (ApplicationData.demoEnabled) {
            Utils.drawString(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_FREE_TRIAL"), this.width >> 1, fontHeight * 5, 17, 0);
        }
        ++this.counterDraw;
        if (this.counterDraw != 2 || ApplicationData.loadApp() == 0) {
            // empty if block
        }
    }

    public void onUpdate(float deltaTime) {
        this.time += deltaTime;
        if (this.time > 4.0f && this.counterDraw > 2) {
            UIScreen.SetCurrentScreen(null);
            Application.getApplication();
            if (!Application.gameCanvas.isForeground) {
                ApplicationData.soundEngine.pauseMID();
            } else if (Options.GfxOnOff) {
                if (ApplicationData.isMainMenuMode()) {
                    CGSoundSystem.PlayMusic("/mainmenu.mid");
                } else {
                    switch (CGEngine.m_nCurrentGalaxy) {
                        case 1: {
                            CGSoundSystem.PlayMusic("/galaxy_1.mid");
                            break;
                        }
                        case 2: {
                            CGSoundSystem.PlayMusic("/galaxy_2.mid");
                            break;
                        }
                        case 3: {
                            CGSoundSystem.PlayMusic("/galaxy_3.mid");
                        }
                    }
                }
            }
            ApplicationData.goToMainMenu();
        }
    }
}

