/*
 * Decompiled with CFR 0.152.
 */
package com.bgate.utils;

import com.bgate.utils.PiPoDesigner;
import javax.microedition.lcdui.Graphics;

public class CustomTextBox {
    public static final int TYPEINPUT_LOW_CASE = 0;
    public static final int TYPEINPUT_UP_CASE = 1;
    public static final int TYPEINPUT_NUMBERIC = 2;
    private final char[] KEY_NUM1_CHARS = new char[]{'.', '1', '!', '?'};
    private final char[] KEY_NUM2_CHARS = new char[]{'a', 'b', 'c', '2'};
    private final char[] KEY_NUM3_CHARS = new char[]{'d', 'e', 'f', '3'};
    private final char[] KEY_NUM4_CHARS = new char[]{'g', 'h', 'i', '4'};
    private final char[] KEY_NUM5_CHARS = new char[]{'j', 'k', 'l', '5'};
    private final char[] KEY_NUM6_CHARS = new char[]{'m', 'n', 'o', '6'};
    private final char[] KEY_NUM7_CHARS = new char[]{'p', 'q', 'r', 's', '7'};
    private final char[] KEY_NUM8_CHARS = new char[]{'t', 'u', 'v', '8'};
    private final char[] KEY_NUM9_CHARS = new char[]{'w', 'x', 'y', 'z', '9'};
    private final char[] KEY_NUM0_CHARS = new char[]{' ', '0'};
    private final char[] KEY_NUM1_CHARS_UP = new char[]{'.', '?', '!', '1'};
    private final char[] KEY_NUM2_CHARS_UP = new char[]{'A', 'B', 'C', '2'};
    private final char[] KEY_NUM3_CHARS_UP = new char[]{'D', 'E', 'F', '3'};
    private final char[] KEY_NUM4_CHARS_UP = new char[]{'G', 'H', 'I', '4'};
    private final char[] KEY_NUM5_CHARS_UP = new char[]{'J', 'K', 'L', '5'};
    private final char[] KEY_NUM6_CHARS_UP = new char[]{'M', 'N', 'O', '6'};
    private final char[] KEY_NUM7_CHARS_UP = new char[]{'P', 'Q', 'R', 'S', '7'};
    private final char[] KEY_NUM8_CHARS_UP = new char[]{'T', 'U', 'V', '8'};
    private final char[] KEY_NUM9_CHARS_UP = new char[]{'W', 'X', 'Y', 'Z', '9'};
    private final char[] KEY_NUM0_CHARS_UP = new char[]{' ', '0'};
    private final char[] KEY_NUM1 = new char[]{'1'};
    private final char[] KEY_NUM2 = new char[]{'2'};
    private final char[] KEY_NUM3 = new char[]{'3'};
    private final char[] KEY_NUM4 = new char[]{'4'};
    private final char[] KEY_NUM5 = new char[]{'5'};
    private final char[] KEY_NUM6 = new char[]{'6'};
    private final char[] KEY_NUM7 = new char[]{'7'};
    private final char[] KEY_NUM8 = new char[]{'8'};
    private final char[] KEY_NUM9 = new char[]{'9'};
    private final char[] KEY_NUM0 = new char[]{'0'};
    public static char[] keynameQweryLowsCase = new char[]{'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p', 'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', 'z', 'x', 'c', 'v', 'b', 'n', 'm', ',', '.', ' ', '@', '?', '\"', '(', ')', '1', '2', '3', '*', '+', '=', '4', '5', '6', '#', '-', '7', '8', '9', '0', ';', ':', '!', 'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', 'A', 'S', 'D', 'F', 'G', 'H', 'J', 'K', 'L', 'Z', 'X', 'C', 'V', 'B', 'N', 'M'};
    public static int[] keycodeQwerty = new int[]{113, 119, 101, 114, 116, 121, 117, 105, 111, 112, 97, 115, 100, 102, 103, 104, 106, 107, 108, 122, 120, 99, 118, 98, 110, 109, 44, 46, 32, 64, 63, 34, 40, 41, 49, 50, 51, 42, 43, 61, 52, 53, 54, 35, 45, 55, 56, 57, 48, 59, 58, 33, 81, 87, 69, 82, 84, 89, 85, 73, 79, 80, 65, 83, 68, 70, 71, 72, 74, 75, 76, 90, 88, 67, 86, 66, 78, 77};
    private int[] keyCodeQwertyNumber = new int[]{109, 114, 116, 121, 102, 103, 104, 118, 98, 110};
    private String[] numberList = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private boolean isFocus;
    private boolean isUseKeyPad;
    public boolean isShowAsterik;
    private boolean isShowTypeInput;
    private int textColor;
    private int borderColor;
    private int typeInput;
    private int textBoxX;
    private int textBoxY;
    private int textBoxWidth;
    private int textBoxHeight;
    int clearKeyCode = Integer.MIN_VALUE;
    StringBuffer currentText = new StringBuffer();
    StringBuffer passText;
    int lastPressedKey = Integer.MIN_VALUE;
    int currentKeyStep = 0;
    int inputWidth = 0;
    int inputHeight = 17;
    int inputTranslationX = 0;
    int caretIndex = 0;
    int caretLeft = 0;
    long caretBlinkDelay = 500L;
    long lastCaretBlink = 0L;
    long lastKeyTimestamp = 0L;
    long maxKeyDelay = 500L;
    boolean goToNextChar = true;
    boolean caretBlinkOn = true;
    int amount = 18;
    private String[] txtIntro = new String[]{"abc", "ABC", "123"};
    private char[] chars;

    public CustomTextBox(int borderColor, int textColor, boolean isShowAsterik, boolean keyPad) {
        this.isUseKeyPad = keyPad;
        this.isFocus = true;
        this.borderColor = borderColor;
        this.textColor = textColor;
        this.isShowAsterik = isShowAsterik;
        if (this.isUseKeyPad) {
            this.isShowTypeInput = true;
        }
        if (isShowAsterik) {
            this.passText = new StringBuffer();
        }
    }

    public void setTypeInput(int type) {
        this.typeInput = type;
    }

    public void setShowTypeInput(boolean isShow) {
        this.isShowTypeInput = isShow;
    }

    public void setFocus(boolean focus) {
        this.isFocus = focus;
    }

    public void setText(String text) {
        this.currentText.setLength(0);
        this.currentText.append(text);
        this.caretIndex = this.currentText.length();
        this.updateCaretPosition();
    }

    public void setPass(String text) {
        this.passText.setLength(0);
        this.passText.append(text);
        String starStr = "";
        for (int i = 0; i < text.length(); ++i) {
            starStr = starStr + "*";
        }
        this.currentText.append(starStr);
        this.caretIndex = this.currentText.length();
        this.updateCaretPosition();
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public void sizeChage(int w, int h) {
        this.isUseKeyPad = w < h;
    }

    public void doSoftKeyRight() {
        if (this.isFocus) {
            this.deleteLeftChar();
            if (!this.isUseKeyPad) {
                this.updateCaretPosition();
            }
        }
    }

    public void doKeyPound() {
        this.changeInputType();
    }

    public void doInputChar(int keyCode) {
        if (this.isUseKeyPad) {
            if (this.getText().length() < this.amount) {
                this.checkNumbericKeyPad(keyCode);
            }
        } else if (this.getText().length() < this.amount) {
            this.checkQwertyKeyPad(keyCode);
        }
    }

    public void inputChar(int key) {
        if (this.isFocus && this.getText().length() < this.amount) {
            this.doInputChar(key);
        }
    }

    public void poiterPressed(int x, int y) {
        if (this.textBoxX - 10 < x && x < this.textBoxX + this.textBoxWidth + 10 && this.textBoxY - 10 < y && y < this.textBoxY + this.textBoxHeight + 10) {
            this.isFocus = true;
        }
    }

    public boolean isFocus() {
        return this.isFocus;
    }

    public String getText() {
        return this.currentText.toString();
    }

    public String getPassWord() {
        return this.passText.toString();
    }

    private void changeInputType() {
        ++this.typeInput;
        this.typeInput %= 3;
    }

    private char[] getChars(int key) {
        switch (key) {
            case 49: {
                if (this.typeInput == 0) {
                    return this.KEY_NUM1_CHARS;
                }
                if (this.typeInput == 1) {
                    return this.KEY_NUM1_CHARS_UP;
                }
                return this.KEY_NUM1;
            }
            case 50: {
                if (this.typeInput == 0) {
                    return this.KEY_NUM2_CHARS;
                }
                if (this.typeInput == 1) {
                    return this.KEY_NUM2_CHARS_UP;
                }
                return this.KEY_NUM2;
            }
            case 51: {
                if (this.typeInput == 0) {
                    return this.KEY_NUM3_CHARS;
                }
                if (this.typeInput == 1) {
                    return this.KEY_NUM3_CHARS_UP;
                }
                return this.KEY_NUM3;
            }
            case 52: {
                if (this.typeInput == 0) {
                    return this.KEY_NUM4_CHARS;
                }
                if (this.typeInput == 1) {
                    return this.KEY_NUM4_CHARS_UP;
                }
                return this.KEY_NUM4;
            }
            case 53: {
                if (this.typeInput == 0) {
                    return this.KEY_NUM5_CHARS;
                }
                if (this.typeInput == 1) {
                    return this.KEY_NUM5_CHARS_UP;
                }
                return this.KEY_NUM5;
            }
            case 54: {
                if (this.typeInput == 0) {
                    return this.KEY_NUM6_CHARS;
                }
                if (this.typeInput == 1) {
                    return this.KEY_NUM6_CHARS_UP;
                }
                return this.KEY_NUM6;
            }
            case 55: {
                if (this.typeInput == 0) {
                    return this.KEY_NUM7_CHARS;
                }
                if (this.typeInput == 1) {
                    return this.KEY_NUM7_CHARS_UP;
                }
                return this.KEY_NUM7;
            }
            case 56: {
                if (this.typeInput == 0) {
                    return this.KEY_NUM8_CHARS;
                }
                if (this.typeInput == 1) {
                    return this.KEY_NUM8_CHARS_UP;
                }
                return this.KEY_NUM8;
            }
            case 57: {
                if (this.typeInput == 0) {
                    return this.KEY_NUM9_CHARS;
                }
                if (this.typeInput == 1) {
                    return this.KEY_NUM9_CHARS_UP;
                }
                return this.KEY_NUM9;
            }
            case 48: {
                if (this.typeInput == 0) {
                    return this.KEY_NUM0_CHARS;
                }
                if (this.typeInput == 1) {
                    return this.KEY_NUM0_CHARS_UP;
                }
                return this.KEY_NUM0;
            }
        }
        return null;
    }

    void updateCaretPosition() {
        this.caretLeft = PiPoDesigner.stringWidth(this.currentText.toString());
    }

    private void checkNumbericKeyPad(int key) {
        this.writeKeyPressed(key);
    }

    private void checkQwertyKeyPad(int key) {
        if (this.typeInput != 2) {
            for (int i = 0; i < keycodeQwerty.length; ++i) {
                if (key != keycodeQwerty[i]) continue;
                this.goToNextChar = true;
                if (this.isShowAsterik) {
                    this.currentText.insert(this.caretIndex, '*');
                    this.passText.insert(this.caretIndex, keynameQweryLowsCase[i]);
                } else {
                    this.currentText.insert(this.caretIndex, keynameQweryLowsCase[i]);
                }
                ++this.caretIndex;
                this.updateCaretPosition();
                break;
            }
            return;
        }
        for (int i = 0; i < this.keyCodeQwertyNumber.length; ++i) {
            if (key != this.keyCodeQwertyNumber[i]) continue;
            this.goToNextChar = true;
            if (this.isShowAsterik) {
                this.currentText.insert(this.caretIndex, '*');
                this.passText.insert(this.caretIndex, this.numberList[i]);
            } else {
                this.currentText.insert(this.caretIndex, this.numberList[i]);
            }
            ++this.caretIndex;
            this.updateCaretPosition();
            break;
        }
    }

    public void moveCurseurLeft() {
        if (!this.isFocus) {
            return;
        }
        if (this.caretIndex > 0) {
            --this.caretIndex;
            this.updateCaretPosition();
            this.goToNextChar = true;
        }
    }

    public void moveCurseurRight() {
        if (!this.isFocus) {
            return;
        }
        if (this.caretIndex < this.currentText.length()) {
            if (this.goToNextChar) {
                ++this.caretIndex;
            }
            this.updateCaretPosition();
            this.goToNextChar = true;
        }
    }

    private void deleteLeftChar() {
        if (this.currentText.length() > 0 && this.caretIndex > 0) {
            --this.caretIndex;
            this.currentText.deleteCharAt(this.caretIndex);
            this.updateCaretPosition();
            if (this.isShowAsterik) {
                this.passText.deleteCharAt(this.caretIndex);
                this.updateCaretPosition();
            }
        }
    }

    private void paintBorder(Graphics g, int x, int y, int width, int height) {
        g.setColor(255, 255, 255);
        g.fillRoundRect(x, y, width - 10, height, 0, 0);
    }

    private void paintCharType(Graphics g, int x, int y, int width, int height) {
        if (this.isFocus) {
            g.setColor(255, 255, 255);
            g.fillRoundRect(x, y, width - 10, height, 0, 0);
            g.setColor(255, 0, 0);
            g.fillRect(x + width - 42, y + 1, 31, height - 2);
            PiPoDesigner.drawString(g, this.txtIntro[this.typeInput], -16777216, -1, x + width - 40, y + (height / 2 - 8));
        }
    }

    public void paint(Graphics g, int x, int y, int width, int height) {
        this.textBoxX = x;
        this.textBoxY = y;
        this.textBoxWidth = width;
        this.textBoxHeight = height;
        this.paintBorder(g, x, y, width, height);
        if (this.isShowTypeInput) {
            this.paintCharType(g, x, y, width, height);
        }
        PiPoDesigner.drawString(g, this.currentText.toString(), -16777216, -16777216, x += 5, y + (height / 2 - 8));
        if (this.caretBlinkOn && this.goToNextChar && this.isFocus) {
            g.setColor(0, 44, 55);
            g.drawLine(x + this.caretLeft, y, x + this.caretLeft, y + this.inputHeight);
        }
    }

    public void run() {
        if (this.isFocus) {
            this.checkTimestamps();
        }
    }

    private void showAsterik() {
        if (this.caretIndex == 0) {
            return;
        }
        this.currentText.setCharAt(this.caretIndex - 1, '*');
        this.updateCaretPosition();
    }

    public void checkTimestamps() {
        long currentTime = System.currentTimeMillis();
        if (this.lastCaretBlink + this.caretBlinkDelay < currentTime) {
            this.caretBlinkOn = !this.caretBlinkOn;
            this.lastCaretBlink = currentTime;
        }
        if (!this.goToNextChar && this.lastKeyTimestamp + this.maxKeyDelay < currentTime) {
            try {
                if (this.isShowAsterik) {
                    this.showAsterik();
                }
                this.goToNextChar = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void writeKeyPressed(int key) {
        if (this.goToNextChar || key != this.lastPressedKey) {
            this.goToNextChar = true;
            this.lastPressedKey = key;
            this.currentKeyStep = 0;
        } else {
            ++this.currentKeyStep;
        }
        this.chars = this.getChars(key);
        if (this.chars != null) {
            if (this.currentKeyStep >= this.chars.length) {
                this.currentKeyStep -= this.chars.length;
            }
            if (this.goToNextChar) {
                this.currentText.insert(this.caretIndex, this.chars[this.currentKeyStep]);
                if (this.isShowAsterik) {
                    this.showAsterik();
                    this.passText.insert(this.caretIndex, this.chars[this.currentKeyStep]);
                }
                ++this.caretIndex;
            } else {
                if (this.caretIndex <= 0) {
                    return;
                }
                this.currentText.setCharAt(this.caretIndex - 1, this.chars[this.currentKeyStep]);
                if (this.isShowAsterik) {
                    this.passText.setCharAt(this.caretIndex - 1, this.chars[this.currentKeyStep]);
                }
            }
            this.updateCaretPosition();
            this.lastKeyTimestamp = System.currentTimeMillis();
            this.goToNextChar = false;
        }
    }
}

