/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngineRenderer;
import java.util.Vector;

public class HitAnimationObject {
    public static final float eWidth = 128.0f;
    public static final float eHeight = 128.0f;
    public static final int eSize = 4;
    public static final int eMaxTime = 200;
    public float m_fPosX;
    public float m_fPosY;
    public int m_nType;
    public int m_nTime;
    protected static Vector m_List = null;
    protected static Vector m_TmpList = null;
    protected static CGTexture[] m_arrTextures;

    public void Destroy() {
    }

    public static void Reset() {
        int nS = m_List.size();
        if (nS > 0) {
            for (int i = nS - 1; i >= 0; --i) {
                m_TmpList.addElement(m_List.elementAt(i));
            }
            m_List.removeAllElements();
        }
    }

    public void Step(int nDeltaTimeInMs) {
        this.m_nTime += nDeltaTimeInMs;
    }

    public void Render() {
        if (this.m_nTime < 200) {
            int nFrame = (int)(4.0f * (float)this.m_nTime / 200.0f);
            if (nFrame >= 4) {
                nFrame = 3;
            }
            CGTexture t = m_arrTextures[this.m_nType * 4 + nFrame];
            CGEngineRenderer.RenderHitAnimationObject(t, this.m_fPosX, this.m_fPosY);
        }
    }

    public static void Init() {
        if (m_arrTextures == null) {
            m_arrTextures = new CGTexture[8];
            HitAnimationObject.m_arrTextures[0] = TextureManager.CreateTexture("/gameplay/hit_1.png");
            HitAnimationObject.m_arrTextures[1] = TextureManager.CreateTexture("/gameplay/hit_2.png");
            HitAnimationObject.m_arrTextures[2] = TextureManager.CreateTexture("/gameplay/hit_3.png");
            HitAnimationObject.m_arrTextures[3] = TextureManager.CreateTexture("/gameplay/hit_4.png");
            HitAnimationObject.m_arrTextures[4] = TextureManager.CreateTexture("/gameplay/hit_5.png");
            HitAnimationObject.m_arrTextures[5] = TextureManager.CreateTexture("/gameplay/hit_6.png");
            HitAnimationObject.m_arrTextures[6] = TextureManager.CreateTexture("/gameplay/hit_7.png");
            HitAnimationObject.m_arrTextures[7] = TextureManager.CreateTexture("/gameplay/hit_8.png");
        }
        m_List = new Vector();
        m_TmpList = new Vector();
        for (int i = 0; i < 30; ++i) {
            m_TmpList.addElement(new HitAnimationObject());
        }
    }

    public static void NewItem(float x, float y, int nType) {
        HitAnimationObject to = null;
        if (m_TmpList.size() > 0) {
            to = (HitAnimationObject)m_TmpList.elementAt(0);
            m_TmpList.removeElementAt(0);
        } else {
            to = new HitAnimationObject();
        }
        to.m_fPosX = x;
        to.m_fPosY = y;
        to.m_nTime = 0;
        to.m_nType = nType;
        m_List.addElement(to);
    }

    public static void StepAll(int nDeltaTime) {
        int nS = m_List.size();
        for (int i = nS - 1; i >= 0; --i) {
            HitAnimationObject to = (HitAnimationObject)m_List.elementAt(i);
            to.Step(nDeltaTime);
            if (to.m_nTime < 200) continue;
            m_TmpList.addElement(to);
            m_List.removeElementAt(i);
        }
    }

    public static void RenderAll() {
        int nS = m_List.size();
        for (int i = 0; i < nS; ++i) {
            ((HitAnimationObject)m_List.elementAt(i)).Render();
        }
    }

    public static int GetCurrentSize() {
        return m_List.size();
    }
}

