/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.ui;

import com.jarbull.efw.controller.ResolutionHandler;
import com.jarbull.efw.text.TextWriter;
import com.jarbull.efw.ui.Button;
import javax.microedition.lcdui.Graphics;

public class ShareButton
extends Button {
    private static final int ARROW_WIDTH = 8;
    private static final int ARROW_HEIGHT = 8;
    int bubblePosX;
    int bubblePosY;
    int bubbleWidth;
    int bubbleHeight;
    boolean bubbleUp;
    int arrowOffset;

    public ShareButton(String id) {
        super(id);
    }

    public void setPosition(int x, int y) {
        super.setPosition(x, y);
        this.placeBubble();
    }

    public void setText(String text) {
        super.setText(text);
        this.placeBubble();
    }

    public void paint(Graphics g) {
        this.saveClip(g);
        g.translate(this.x, this.y);
        if (this.bg != null) {
            this.bg.paint(g);
        }
        if (this.fg != null) {
            this.fg.paint(g);
        }
        if (this.selected) {
            g.setColor(0xFF0000);
            g.drawRect(0, 0, this.width - 1, this.height - 1);
            this.drawBubble(g);
        }
        g.translate(-this.x, -this.y);
        this.restoreClip(g);
    }

    void placeBubble() {
        if (this.text == null) {
            return;
        }
        TextWriter.getInstance().saveState();
        TextWriter.getInstance().setWriterType(2);
        this.bubbleWidth = TextWriter.getInstance().getTextWidth(this.text) + 10;
        this.bubbleHeight = TextWriter.getInstance().getTextHeight(this.text);
        if (this.x < ResolutionHandler.getInstance().getCurrentWidth() / 2) {
            this.bubblePosX = 0;
            this.arrowOffset = 8;
        } else {
            this.bubblePosX = this.width - this.bubbleWidth;
            this.arrowOffset = 0;
        }
        if (this.y < ResolutionHandler.getInstance().getCurrentHeight() / 2) {
            this.bubblePosY = this.height + 8;
            this.bubbleUp = false;
        } else {
            this.bubblePosY = -this.bubbleHeight - 8;
            this.bubbleUp = true;
        }
        TextWriter.getInstance().restoreState();
    }

    void drawBubble(Graphics g) {
        TextWriter.getInstance().saveState();
        TextWriter.getInstance().setWriterType(2);
        g.setColor(0);
        g.fillRoundRect(this.bubblePosX, this.bubblePosY, this.bubbleWidth, this.bubbleHeight, 8, 8);
        g.setColor(0xFFFFFF);
        g.drawRoundRect(this.bubblePosX, this.bubblePosY, this.bubbleWidth, this.bubbleHeight, 8, 8);
        g.setColor(0);
        g.fillTriangle(this.arrowOffset, this.bubbleUp ? -9 : this.height + 8, this.arrowOffset + 8, this.bubbleUp ? -9 : this.height + 8, this.arrowOffset + 4, this.bubbleUp ? 0 : this.height);
        g.setColor(0xFFFFFF);
        g.drawLine(this.arrowOffset + 4, this.bubbleUp ? 0 : this.height, this.arrowOffset, this.bubbleUp ? -8 : this.height + 8);
        g.drawLine(this.arrowOffset + 4, this.bubbleUp ? 0 : this.height, this.arrowOffset + 8, this.bubbleUp ? -8 : this.height + 8);
        g.setColor(0xFFFFFF);
        TextWriter.getInstance().drawText(g, this.text, this.bubblePosX + 5, this.bubblePosY + 1);
        TextWriter.getInstance().restoreState();
    }
}

