/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;

class GS60_GraphicalFont {
    gs60cpd applet;
    public boolean is_phone_font;
    public Font phone_font_id;
    private int num_tint_combos;
    private int[] fg_color;
    private int[] bg_color;
    private Image[] font_images;
    public int font_height;
    private int font_yoff;
    public int font_kerning;
    private int num_split_images;
    private int first_char_in_font;
    private int last_char_in_font;
    private byte[] split_image_num;
    private byte[] split_image_x;
    private byte[] split_image_y;
    private byte[] split_image_w;
    private byte[] split_image_h;
    private byte[] split_image_yoff;
    private int cur_tint_index;
    private int tile_file_data__first_image_index;
    private byte[] temp_file_data;
    private int num_extended_chars;
    private int extended_chars_offset;
    private char[] extended_char;

    GS60_GraphicalFont() {
    }

    private int HELPER_ConvertCharToArrayIndex(char c) {
        if (c <= this.last_char_in_font) {
            return c - this.first_char_in_font;
        }
        for (int i = 0; i < this.num_extended_chars; ++i) {
            if (this.extended_char[i] != c) continue;
            return i + this.extended_chars_offset;
        }
        return 0;
    }

    public void Init(gs60cpd gs60cpd2, String string, Font font, int n, int n2) {
        int n3;
        int n4;
        this.applet = gs60cpd2;
        this.phone_font_id = font;
        this.is_phone_font = false;
        this.num_tint_combos = n;
        this.temp_file_data = this.applet.LoadBinaryDataIntoNewByteBuffer_J2ME_DontCallMe_UseMacroInstead(string, 0);
        GS60_BitStreamReader gS60_BitStreamReader = new GS60_BitStreamReader();
        gS60_BitStreamReader.Init(this.temp_file_data);
        int n5 = gS60_BitStreamReader.Read(8);
        this.font_height = gS60_BitStreamReader.Read(8);
        int n6 = gS60_BitStreamReader.Read(8);
        int n7 = gS60_BitStreamReader.Read(8);
        this.num_split_images = gS60_BitStreamReader.Read(8);
        int n8 = gS60_BitStreamReader.Read(4);
        int n9 = gS60_BitStreamReader.Read(4);
        int n10 = gS60_BitStreamReader.Read(4);
        int n11 = gS60_BitStreamReader.Read(4);
        int n12 = gS60_BitStreamReader.Read(4);
        this.font_kerning = 1;
        int n13 = GS60_BitStreamReader.Utility_BitsReqdToRepresentIntRange(this.num_split_images);
        this.first_char_in_font = gS60_BitStreamReader.Read(8);
        this.last_char_in_font = gS60_BitStreamReader.Read(8);
        int n14 = this.last_char_in_font - this.first_char_in_font + 1;
        if (n5 == 2) {
            this.num_extended_chars = gS60_BitStreamReader.Read(10);
            n4 = gS60_BitStreamReader.Read(5);
            this.extended_char = new char[this.num_extended_chars];
            for (n3 = 0; n3 < this.num_extended_chars; ++n3) {
                this.extended_char[n3] = (char)gS60_BitStreamReader.Read(n4);
            }
            this.extended_chars_offset = n14;
            n14 += this.num_extended_chars;
        }
        this.split_image_num = new byte[n14];
        this.split_image_x = new byte[n14];
        this.split_image_y = new byte[n14];
        this.split_image_w = new byte[n14];
        this.split_image_h = new byte[n14];
        this.split_image_yoff = new byte[n14];
        this.fg_color = new int[n];
        this.bg_color = new int[n];
        this.font_images = new Image[n * this.num_split_images];
        for (n3 = 0; n3 < n14; ++n3) {
            if (gS60_BitStreamReader.Read(1) != 0) {
                this.split_image_num[n3] = (byte)gS60_BitStreamReader.Read(n13);
                this.split_image_x[n3] = (byte)gS60_BitStreamReader.Read(n8);
                this.split_image_y[n3] = (byte)gS60_BitStreamReader.Read(n9);
                this.split_image_w[n3] = (byte)gS60_BitStreamReader.Read(n10);
                this.split_image_h[n3] = (byte)gS60_BitStreamReader.Read(n11);
                this.split_image_yoff[n3] = (byte)gS60_BitStreamReader.Read(n12);
                continue;
            }
            this.split_image_w[n3] = 0;
        }
        if (n7 < n6 * 3 / 4) {
            n4 = n6 * 3 / 4;
            this.font_yoff = n4 - n7;
            this.font_height += this.font_yoff;
            n7 = n4;
        }
        if (n6 < n7 * 3 / 4) {
            n4 = n7 * 3 / 4;
            this.font_height += n4 - n6;
            n6 = n4;
        }
        gS60_BitStreamReader.SyncToByteBoundary();
        this.tile_file_data__first_image_index = gS60_BitStreamReader.GetOffset();
    }

    public void InitPhoneFont(gs60cpd gs60cpd2, Font font, int n) {
        this.applet = gs60cpd2;
        this.is_phone_font = true;
        this.phone_font_id = font;
        this.font_height = font.getHeight();
    }

    public void Release() {
        this.fg_color = null;
        this.bg_color = null;
        this.extended_char = null;
        this.split_image_num = null;
        this.split_image_x = null;
        this.split_image_y = null;
        this.split_image_w = null;
        this.split_image_h = null;
        this.split_image_yoff = null;
        if (this.font_images != null) {
            for (int i = 0; i < this.num_split_images * this.num_tint_combos; ++i) {
                this.font_images[i] = null;
            }
        }
        this.font_images = null;
        this.Finalize();
    }

    public void Tint(int n, int n2, int n3) {
        if (this.cur_tint_index < this.num_tint_combos) {
            int n4 = this.cur_tint_index++;
            this.fg_color[n4] = n2;
            this.bg_color[n4] = n;
            GS60_BitStreamReader gS60_BitStreamReader = new GS60_BitStreamReader();
            gS60_BitStreamReader.Init(this.temp_file_data);
            gS60_BitStreamReader.SetOffset(this.tile_file_data__first_image_index);
            int n5 = n4 * this.num_split_images;
            GS60_Image_Pipeline gS60_Image_Pipeline = new GS60_Image_Pipeline();
            for (int i = 0; i < this.num_split_images; ++i) {
                int n6;
                int n7 = n5 + i;
                this.font_images[n7] = null;
                gS60_BitStreamReader.SyncToByteBoundary();
                int n8 = (gS60_BitStreamReader.GetOffset() >> 3) + 1;
                int n9 = this.temp_file_data[n8++] & 0xFF;
                if (n9 == 0) {
                    n9 = (this.temp_file_data[n8++] & 0xFF) << 8;
                    n9 |= this.temp_file_data[n8++] & 0xFF;
                }
                if ((n6 = this.temp_file_data[n8++] & 0xFF) == 0) {
                    n6 = (this.temp_file_data[n8++] & 0xFF) << 8;
                    n6 |= this.temp_file_data[n8++] & 0xFF;
                }
                gS60_Image_Pipeline.Init(n9, n6);
                gS60_Image_Pipeline.Fill(0xFF00FF);
                gS60_Image_Pipeline.AddFromRLE_LightmapStencilOrImage(gS60_BitStreamReader, 0, 0, n, n2, 33);
                this.font_images[n7] = gS60_Image_Pipeline.CreateImage(this.applet, this.font_images[n7], true);
            }
        }
    }

    public void Finalize() {
        if (this.temp_file_data != null) {
            this.temp_file_data = null;
            this.temp_file_data = null;
        }
    }

    public void SetFontAndColor(int n, int n2, int n3) {
        this.applet.cur_font = this;
        if (this.is_phone_font) {
            this.applet.screen_graphics.setFont(this.phone_font_id);
            this.applet.SetColor(n2);
        } else {
            int n4 = n2 >> 16 & 0xFF;
            int n5 = n2 >> 8 & 0xFF;
            int n6 = n2 & 0xFF;
            int n7 = n >> 16 & 0xFF;
            int n8 = n >> 8 & 0xFF;
            int n9 = n & 0xFF;
            int n10 = 0;
            int n11 = 999999999;
            for (int i = 0; i < this.num_tint_combos; ++i) {
                int n12;
                int n13 = ((this.fg_color[i] >> 16 & 0xFF) - n4 < 0 ? -((this.fg_color[i] >> 16 & 0xFF) - n4) : (this.fg_color[i] >> 16 & 0xFF) - n4) + ((this.fg_color[i] >> 8 & 0xFF) - n5 < 0 ? -((this.fg_color[i] >> 8 & 0xFF) - n5) : (this.fg_color[i] >> 8 & 0xFF) - n5) + ((this.fg_color[i] & 0xFF) - n6 < 0 ? -((this.fg_color[i] & 0xFF) - n6) : (this.fg_color[i] & 0xFF) - n6);
                int n14 = (n13 << 1) + (n12 = ((this.bg_color[i] >> 16 & 0xFF) - n7 < 0 ? -((this.bg_color[i] >> 16 & 0xFF) - n7) : (this.bg_color[i] >> 16 & 0xFF) - n7) + ((this.bg_color[i] >> 8 & 0xFF) - n8 < 0 ? -((this.bg_color[i] >> 8 & 0xFF) - n8) : (this.bg_color[i] >> 8 & 0xFF) - n8) + ((this.bg_color[i] & 0xFF) - n9 < 0 ? -((this.bg_color[i] & 0xFF) - n9) : (this.bg_color[i] & 0xFF) - n9));
                if (n14 >= n11) continue;
                n11 = n14;
                n10 = i;
            }
            this.cur_tint_index = n10;
        }
    }

    public int GetSubstringWidth(String string, int n, int n2) {
        if (this.is_phone_font) {
            return this.applet.screen_graphics.getFont().substringWidth(string, n, n2);
        }
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            n3 += this.split_image_w[this.HELPER_ConvertCharToArrayIndex(string.charAt(i))];
        }
        if (n2 > 1) {
            n3 += (n2 - 1) * this.font_kerning;
        }
        return n3;
    }

    public int GetStringWidth(String string) {
        int n = string.length();
        return this.GetSubstringWidth(string, 0, n);
    }

    public void DrawSubstring(String string, int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.is_phone_font) {
            this.applet.screen_graphics.drawSubstring(string, n, n2, n3, n4 + 0, 20);
        } else {
            int n7 = this.cur_tint_index * this.num_split_images;
            n5 = this.applet.screen_graphics.getClipY();
            n6 = n5 + this.applet.screen_graphics.getClipHeight();
            n4 += this.font_yoff;
            for (int i = n; i < n + n2; ++i) {
                int n8 = this.HELPER_ConvertCharToArrayIndex(string.charAt(i));
                if (this.split_image_w[n8] > 0) {
                    int n9 = n4 + this.split_image_yoff[n8];
                    int n10 = this.split_image_h[n8];
                    if (n5 >= 0) {
                        if (n5 > n9) {
                            int n11 = n5 - n9;
                            n9 += n11;
                            n10 -= n11;
                        }
                        if (n6 < n9 + n10) {
                            n10 = n6 - n9;
                        }
                    }
                    if (n10 > 0) {
                        this.applet.drawSubImage(this.font_images[n7 + this.split_image_num[n8]], n3, n9, this.split_image_w[n8], n10, n3 - this.split_image_x[n8], n4 - this.split_image_y[n8] + this.split_image_yoff[n8]);
                        this.applet.SetClip(0, n5, 240, n6 - n5);
                    }
                    n3 += this.split_image_w[n8];
                }
                n3 += this.font_kerning;
            }
        }
    }

    public void SetReTintIndex(int n) {
        this.cur_tint_index = n;
    }
}

