/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

class GS60_SoundMgr {
    private gs60cpd applet;
    private boolean initialized;
    private int playing_priority;
    private boolean sound_enabled;
    private long last_sound_time;
    private boolean music_enabled;
    private boolean music_loaded;
    private boolean music_playing;
    private Player menu_music;
    private Player playing_sound;
    public Object bg_task_lock = new Object();
    public Player bg_sound_to_play;
    public boolean bg_sound_being_started;

    public int PlayingPriority() {
        return this.playing_priority;
    }

    public boolean IsSoundEnabled() {
        return this.sound_enabled;
    }

    public void EnableSound(boolean bl) {
        this.sound_enabled = bl;
    }

    public boolean IsMusicEnabled() {
        return this.music_enabled;
    }

    public void EnableMusic(boolean bl) {
        this.music_enabled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void BackgroundTask__Process() {
        Player player = null;
        Object object = this.bg_task_lock;
        synchronized (object) {
            if (this.bg_sound_to_play != null) {
                player = this.bg_sound_to_play;
                this.bg_sound_being_started = true;
                this.bg_sound_to_play = null;
            }
        }
        if (player != null) {
            try {
                player.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.bg_sound_being_started = false;
    }

    public boolean IsIdle() {
        if (this.bg_sound_to_play != null || this.bg_sound_being_started) {
            return false;
        }
        return this.playing_sound == null || this.playing_sound.getState() != 400;
    }

    public GS60_SoundMgr(gs60cpd gs60cpd2) {
        this.applet = gs60cpd2;
        this.playing_sound = null;
        this.playing_priority = 0;
        this.sound_enabled = true;
        this.music_enabled = true;
        this.music_loaded = false;
        this.last_sound_time = 0L;
    }

    public Player Load(String string) {
        Player player = null;
        byte[] byArray = null;
        String string2 = null;
        if (byArray == null && this.applet.CheckIfAssetExists_J2ME_DontCallMe_UseMacroInstead(string + ".mp3")) {
            byArray = this.applet.LoadBinaryDataIntoNewByteBuffer_J2ME_DontCallMe_UseMacroInstead(string + ".mp3", 0);
            string2 = "audio/mpeg";
        }
        if (byArray == null && this.applet.CheckIfAssetExists_J2ME_DontCallMe_UseMacroInstead(string + ".amr")) {
            byArray = this.applet.LoadBinaryDataIntoNewByteBuffer_J2ME_DontCallMe_UseMacroInstead(string + ".amr", 0);
            string2 = "audio/amr";
        }
        if (byArray == null && this.applet.CheckIfAssetExists_J2ME_DontCallMe_UseMacroInstead(string + ".wav")) {
            byArray = this.applet.LoadBinaryDataIntoNewByteBuffer_J2ME_DontCallMe_UseMacroInstead(string + ".wav", 0);
            string2 = "audio/x-wav";
        }
        if (byArray == null && this.applet.CheckIfAssetExists_J2ME_DontCallMe_UseMacroInstead(string + ".mid")) {
            byArray = this.applet.LoadBinaryDataIntoNewByteBuffer_J2ME_DontCallMe_UseMacroInstead(string + ".mid", 0);
            string2 = "audio/midi";
        }
        if (byArray != null) {
            try {
                player = Manager.createPlayer((InputStream)new ByteArrayInputStream(byArray), string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (player != null) {
            try {
                player.realize();
            }
            catch (Exception exception) {
                try {
                    player.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                player = null;
            }
        }
        return player;
    }

    public void Unload(Player player) {
        try {
            player.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Play(Player player, int n, long l) {
        long l2 = System.currentTimeMillis();
        if (!(!this.sound_enabled || player == null || this.music_loaded && this.music_enabled || l2 - this.last_sound_time <= l && this.last_sound_time != 0L)) {
            this.last_sound_time = l2;
            if (this.IsIdle() || n >= this.playing_priority) {
                if (player == this.playing_sound && player.getState() == 400) {
                    try {
                        this.playing_sound.setMediaTime(0L);
                        this.playing_priority = n;
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.playing_sound != null) {
                    try {
                        this.playing_sound.stop();
                        try {
                            this.playing_sound.setMediaTime(0L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (this.playing_sound != player) {
                            this.playing_sound.deallocate();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    player.setMediaTime(0L);
                    Object object = this.bg_task_lock;
                    synchronized (object) {
                        this.bg_sound_to_play = player;
                    }
                    this.playing_sound = player;
                    this.playing_priority = n;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void StopAll() {
        if (!this.IsIdle()) {
            Object object = this.bg_task_lock;
            synchronized (object) {
                this.bg_sound_to_play = null;
            }
            if (this.playing_sound != null) {
                try {
                    this.playing_sound.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.playing_sound.setMediaTime(0L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.playing_sound.deallocate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.playing_sound = null;
            this.playing_priority = 0;
        }
    }

    public void Sound_Pause() {
        try {
            this.playing_sound.stop();
            this.menu_music = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void Sound_Resume() {
        try {
            this.playing_sound.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void Sound_Process() {
        if (this.music_loaded) {
            if (this.music_enabled && this.sound_enabled) {
                if (this.IsIdle()) {
                    this.music_loaded = false;
                    this.Play(this.menu_music, 100, 0L);
                    this.music_playing = true;
                    this.music_loaded = true;
                }
            } else if (this.music_playing && !this.IsIdle()) {
                this.StopAll();
                this.music_playing = false;
            }
        }
    }

    public void Music_LoadAndPlay(String string) {
        if (!this.music_loaded) {
            this.menu_music = this.Load(string);
            if (this.menu_music != null) {
                this.music_loaded = true;
            }
        }
    }

    public void Music_StopAndUnload() {
        if (this.music_loaded) {
            this.StopAll();
            this.Unload(this.menu_music);
            this.music_loaded = false;
            this.menu_music = null;
        }
    }
}

