/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Material;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;

public class MeshLoader {
    private static final int MagickNumber = 20090521;
    private static final int EndNumber = 1701;
    private static final int MIN_STRIP_LENGTH = 8;
    private static boolean readInNormals = false;
    private static float VERTEX_SCALE = 58.333332f;
    private static float BUFFER_SCALE = 0.0015686274f;
    private static Vector Paths = new Vector();
    private static Vector VertexBuffers = new Vector();
    private static Vector IndexBuffers = new Vector();
    private static Hashtable Apps = new Hashtable();
    private static Vector MaterialContainers = new Vector();
    private static Vector Sizes = new Vector();
    private static Vector BoneNames = new Vector();
    private static Vector Bones = new Vector();
    static /* synthetic */ Class class$MeshLoader;

    public static void setBufferScale(float f) {
        BUFFER_SCALE = f;
    }

    public static void setVertexScale(float f) {
        VERTEX_SCALE = f;
    }

    public static float getBufferScale() {
        return BUFFER_SCALE;
    }

    public static float getVertexScale() {
        return VERTEX_SCALE;
    }

    public static boolean loadVam(String path, String skinpath, Object[] buffers, float scale) {
        return MeshLoader.loadVam(path, skinpath, buffers, null, null, null, scale);
    }

    public static boolean loadVam(String path, String skinpath, Object[] buffers, float[] size, float scale) {
        return MeshLoader.loadVam(path, skinpath, buffers, size, null, null, scale);
    }

    public static boolean loadVam(String path, String skinpath, Object[] buffers, String[] names, Vector3D[] bones, float scale) {
        return MeshLoader.loadVam(path, skinpath, buffers, null, names, bones, scale);
    }

    public static boolean loadVam(String path, String skinpath, Object[] buffers) {
        return MeshLoader.loadVam(path, skinpath, buffers, null, null, null, 1.0f);
    }

    public static boolean loadVam(String path, String skinpath, Object[] buffers, float[] size) {
        return MeshLoader.loadVam(path, skinpath, buffers, size, null, null, 1.0f);
    }

    public static boolean loadVam(String path, String skinpath, Object[] buffers, String[] names, Vector3D[] bones) {
        return MeshLoader.loadVam(path, skinpath, buffers, null, names, bones, 1.0f);
    }

    public static boolean loadVam(String path, String skinpath, Object[] buffers, float[] size, String[] names, Vector3D[] bones) {
        return MeshLoader.loadVam(path, skinpath, buffers, size, names, bones, 1.0f);
    }

    public static boolean loadVam(String path, String skinpath, Object[] buffers, float[] size, String[] names, Vector3D[] bones, float scale) {
        int index = Paths.contains(path) ? Paths.indexOf(path) : MeshLoader.readIn(path, scale);
        if (index == -1) {
            return false;
        }
        buffers[0] = VertexBuffers.elementAt(index);
        buffers[1] = IndexBuffers.elementAt(index);
        buffers[2] = MeshLoader.getAppearance(skinpath, (MaterialContainer)MaterialContainers.elementAt(index));
        if (size != null) {
            float[] f = (float[])Sizes.elementAt(index);
            if (size.length == 3) {
                size[1] = Math.abs(f[2] - f[3]);
                size[2] = Math.abs(f[4] - f[5]);
                size[0] = Math.abs(f[0] - f[1]);
            } else if (size.length == 6) {
                size[0] = f[0];
                size[1] = f[1];
                size[2] = f[2];
                size[3] = f[3];
                size[4] = f[4];
                size[5] = f[5];
            }
        }
        if (names != null && bones != null) {
            String[] bonenamearray = (String[])BoneNames.elementAt(index);
            Vector3D[] bonesarray = (Vector3D[])Bones.elementAt(index);
            for (int i = 0; i < bones.length; ++i) {
                int id = MeshLoader.contains(names[i], bonenamearray);
                if (id < 0) continue;
                bones[i] = new Vector3D();
                bones[i].setx(bonesarray[id].getx());
                bones[i].sety(bonesarray[id].gety());
                bones[i].setz(bonesarray[id].getz());
            }
        }
        return true;
    }

    private static int contains(String s, String[] names) {
        int a = -1;
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(s)) continue;
            a = i;
            break;
        }
        return a;
    }

    private static int readIn(String path, float tempscale) {
        Paths.addElement(path);
        int returnindex = Paths.indexOf(path);
        short[] readinvertices = null;
        short[] readincoordinates = null;
        byte[] readinnormals = null;
        int[] readinindices = null;
        int[] readinstrips = null;
        MaterialContainer matcon = new MaterialContainer();
        String img = null;
        float maxw = 0.0f;
        float minw = 0.0f;
        float maxh = 0.0f;
        float minh = 0.0f;
        float maxl = 0.0f;
        float minl = 0.0f;
        DataInputStream din = new DataInputStream((class$MeshLoader == null ? (class$MeshLoader = MeshLoader.class$("MeshLoader")) : class$MeshLoader).getResourceAsStream(path));
        if (din == null) {
            System.out.println("No such file: " + path);
            return -1;
        }
        try {
            int i;
            if (din.readInt() != 20090521) {
                System.out.println("File: " + path + " is invalid.");
                return -1;
            }
            int novert = din.readInt();
            readinvertices = new short[novert * 3];
            readincoordinates = new short[novert * 2];
            readinnormals = new byte[novert * 3];
            for (i = 0; i < novert; ++i) {
                float v1 = din.readFloat();
                float v2 = din.readFloat();
                float v3 = din.readFloat();
                readinvertices[i * 3] = (short)(v1 * VERTEX_SCALE);
                readinvertices[i * 3 + 1] = (short)(v2 * VERTEX_SCALE);
                readinvertices[i * 3 + 2] = (short)(v3 * VERTEX_SCALE);
                if (v1 * VERTEX_SCALE * (BUFFER_SCALE * tempscale) > maxw) {
                    maxw = v1 * VERTEX_SCALE * (BUFFER_SCALE * tempscale);
                }
                if (v1 * VERTEX_SCALE * (BUFFER_SCALE * tempscale) < minw) {
                    minw = v1 * VERTEX_SCALE * (BUFFER_SCALE * tempscale);
                }
                if (v2 * VERTEX_SCALE * (BUFFER_SCALE * tempscale) > maxh) {
                    maxh = v2 * VERTEX_SCALE * (BUFFER_SCALE * tempscale);
                }
                if (v2 * VERTEX_SCALE * (BUFFER_SCALE * tempscale) < minh) {
                    minh = v2 * VERTEX_SCALE * (BUFFER_SCALE * tempscale);
                }
                if (v3 * VERTEX_SCALE * (BUFFER_SCALE * tempscale) > maxl) {
                    maxl = v3 * VERTEX_SCALE * (BUFFER_SCALE * tempscale);
                }
                if (!(v3 * VERTEX_SCALE * (BUFFER_SCALE * tempscale) < minl)) continue;
                minl = v3 * VERTEX_SCALE * (BUFFER_SCALE * tempscale);
            }
            for (i = 0; i < novert; ++i) {
                readincoordinates[i * 2] = (short)(din.readFloat() * 256.0f);
                readincoordinates[i * 2 + 1] = (short)(255.0f - din.readFloat() * 256.0f);
            }
            for (i = 0; i < novert; ++i) {
                float n1 = din.readFloat();
                float n2 = din.readFloat();
                float n3 = din.readFloat();
                readinnormals[i * 3] = (byte)(n1 * 128.0f);
                readinnormals[i * 3 + 1] = (byte)(n2 * 128.0f);
                readinnormals[i * 3 + 2] = (byte)(n3 * 128.0f);
            }
            int noobj = din.readInt();
            Vector3D[] bonesarray = new Vector3D[noobj - 1];
            String[] bonenamearray = new String[noobj - 1];
            int currentbone = 0;
            for (int i2 = 0; i2 < noobj; ++i2) {
                int nocharname = din.readInt();
                String name = "";
                for (int a = 0; a < nocharname; ++a) {
                    name = name + din.readChar();
                }
                matcon.ambient = din.readLong();
                matcon.diffuse = din.readLong();
                matcon.emissive = din.readLong();
                matcon.specular = din.readLong();
                matcon.shine = din.readFloat() / 2.0f;
                MaterialContainers.addElement(matcon);
                int nochartexture = din.readInt();
                img = path.substring(0, path.lastIndexOf(47) + 1);
                for (int a = 0; a < nochartexture; ++a) {
                    img = img + din.readChar();
                }
                int noindices = din.readInt();
                readinindices = new int[noindices];
                for (int a = 0; a < noindices; ++a) {
                    readinindices[a] = din.readInt();
                }
                int nostrips = din.readInt();
                readinstrips = new int[nostrips];
                for (int a = 0; a < nostrips; ++a) {
                    readinstrips[a] = din.readInt();
                }
                if (nostrips < 8 && noobj > 1) {
                    bonenamearray[currentbone] = new String(name.trim());
                    bonesarray[currentbone] = new Vector3D();
                    bonesarray[currentbone].setx((float)readinvertices[readinindices[0] * 3] * (BUFFER_SCALE * tempscale));
                    bonesarray[currentbone].sety((float)readinvertices[readinindices[0] * 3 + 1] * (BUFFER_SCALE * tempscale));
                    bonesarray[currentbone].setz((float)readinvertices[readinindices[0] * 3 + 2] * (BUFFER_SCALE * tempscale));
                    ++currentbone;
                    continue;
                }
                VertexArray va = new VertexArray(readinvertices.length / 3, 3, 2);
                va.set(0, readinvertices.length / 3, readinvertices);
                float[] pbias = new float[]{0.003921569f, 0.003921569f, 0.003921569f};
                VertexBuffer vertbuf = new VertexBuffer();
                vertbuf.setPositions(va, BUFFER_SCALE * tempscale, pbias);
                if (readInNormals) {
                    VertexArray normArray = new VertexArray(readinnormals.length / 3, 3, 1);
                    normArray.set(0, readinnormals.length / 3, readinnormals);
                    vertbuf.setNormals(normArray);
                }
                VertexArray texArray = new VertexArray(readincoordinates.length / 2, 2, 2);
                texArray.set(0, readincoordinates.length / 2, readincoordinates);
                vertbuf.setTexCoords(0, texArray, 0.003921569f, null);
                TriangleStripArray indbuf = new TriangleStripArray(readinindices, readinstrips);
                VertexBuffers.addElement(vertbuf);
                IndexBuffers.addElement(indbuf);
            }
            float[] size = new float[]{maxw, minw, maxh, minh, maxl, minl};
            Sizes.addElement(size);
            BoneNames.addElement(bonenamearray);
            Bones.addElement(bonesarray);
            if (din.readInt() != 1701) {
                return -1;
            }
            din.close();
        }
        catch (Exception e) {
            System.out.println("Error while loading mesh: \"" + path + "\" !");
            e.printStackTrace();
            return -1;
        }
        return returnindex;
    }

    private static Appearance getAppearance(String imgpath, MaterialContainer matcon) {
        if (Apps.containsKey(imgpath)) {
            return (Appearance)Apps.get(imgpath);
        }
        Texture2D tex = new Texture2D(SpriteLoader.LoadSprite(imgpath));
        tex.setBlending(228);
        Appearance app = new Appearance();
        app.setTexture(0, tex);
        if (readInNormals) {
            Material mat = new Material();
            mat.setColor(1024, (int)matcon.ambient);
            mat.setColor(4096, (int)matcon.emissive);
            mat.setColor(2048, (int)matcon.diffuse);
            mat.setColor(8192, (int)matcon.specular);
            mat.setShininess(matcon.shine);
            app.setMaterial(mat);
        }
        PolygonMode pm = new PolygonMode();
        pm.setPerspectiveCorrectionEnable(false);
        pm.setCulling(162);
        pm.setWinding(168);
        pm.setLocalCameraLightingEnable(false);
        pm.setTwoSidedLightingEnable(false);
        pm.setShading(164);
        CompositingMode cm = new CompositingMode();
        cm.setDepthTestEnable(true);
        cm.setDepthWriteEnable(true);
        cm.setAlphaWriteEnable(true);
        cm.setAlphaThreshold(0.5f);
        cm.setBlending(64);
        app.setPolygonMode(pm);
        app.setCompositingMode(cm);
        Apps.put(imgpath, app);
        return app;
    }

    public static void free() {
        Paths.removeAllElements();
        VertexBuffers.removeAllElements();
        IndexBuffers.removeAllElements();
        Sizes.removeAllElements();
        BoneNames.removeAllElements();
        Bones.removeAllElements();
        MaterialContainers.removeAllElements();
        Apps.clear();
        try {
            Thread.sleep(250L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

