/*
 * Decompiled with CFR 0.152.
 */
public class Vector3D {
    private float x;
    private float y;
    private float z;
    private float length;
    private boolean isChanged;

    public Vector3D() {
        this.length = 0.0f;
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.isChanged = false;
    }

    public Vector3D(float vx, float vy, float vz) {
        this.x = vx;
        this.y = vy;
        this.z = vz;
        this.isChanged = true;
    }

    public Vector3D(Vector3D v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.isChanged = true;
    }

    public void set(float vx, float vy, float vz) {
        this.x = vx;
        this.y = vy;
        this.z = vz;
        this.isChanged = true;
    }

    public void set(Vector3D v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.isChanged = true;
    }

    public Vector3D get() {
        return new Vector3D(this);
    }

    public float getx() {
        return this.x;
    }

    public float gety() {
        return this.y;
    }

    public float getz() {
        return this.z;
    }

    public void setx(float x) {
        this.x = x;
        this.isChanged = true;
    }

    public void sety(float y) {
        this.y = y;
        this.isChanged = true;
    }

    public void setz(float z) {
        this.z = z;
        this.isChanged = true;
    }

    public static float dotProduct(Vector3D u, Vector3D v) {
        return u.x * v.x + u.y * v.y + u.z * v.z;
    }

    public float dotProduct(Vector3D u) {
        return this.x * u.x + this.y * u.y + this.z * u.z;
    }

    public static Vector3D crossProduct(Vector3D u, Vector3D v) {
        return new Vector3D(u.y * v.z - u.z * v.y, -u.x * v.z + u.z * v.x, u.x * v.y - u.y * v.x);
    }

    public void crossProduct(Vector3D v) {
        float nx = this.y * v.z - this.z * v.y;
        float ny = -this.x * v.z + this.z * v.x;
        float nz = this.x * v.y - this.y * v.x;
        this.x = nx;
        this.y = ny;
        this.z = nz;
        this.isChanged = true;
    }

    public static float length(Vector3D v) {
        return v.length();
    }

    public float length() {
        if (this.isChanged) {
            this.length = (float)mMath.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
            this.isChanged = false;
        }
        return this.length;
    }

    public static float quaterLength(Vector3D v) {
        return v.quaterLength();
    }

    public float quaterLength() {
        if (this.isChanged) {
            return this.x * this.x + this.y * this.y + this.z * this.z;
        }
        return this.length * this.length;
    }

    public void setLength(float l) {
        if (l == 0.0f) {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 0.0f;
            this.length = 0.0f;
            this.isChanged = false;
        } else {
            this.normalize();
            this.scalarMul(l);
        }
    }

    public static Vector3D project(Vector3D v, Vector3D u) {
        float lenU = Vector3D.length(u);
        float scalar = Vector3D.dotProduct(v, u) / (lenU * lenU);
        return Vector3D.scalarMul(scalar, u);
    }

    public static Vector3D calcNormal(Vector3D v, Vector3D u) {
        Vector3D cross = Vector3D.crossProduct(v, u);
        return Vector3D.normalize(cross);
    }

    public static Vector3D normalize(Vector3D v) {
        float len = v.length();
        if (len == 0.0f) {
            len = 0.001f;
        }
        return new Vector3D(v.x / len, v.y / len, v.z / len);
    }

    public void normalize() {
        float len = this.length();
        if (len == 0.0f) {
            len = 0.001f;
        }
        this.x /= len;
        this.y /= len;
        this.z /= len;
        this.length = 1.0f;
        this.isChanged = false;
    }

    public static Vector3D scalarMul(float scalar, Vector3D v) {
        return new Vector3D(v.x * scalar, v.y * scalar, v.z * scalar);
    }

    public void scalarMul(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        this.length *= scalar;
    }

    public static Vector3D scalarDiv(float scalar, Vector3D v) {
        return new Vector3D(v.x / scalar, v.y / scalar, v.z / scalar);
    }

    public void scalarDiv(float scalar) {
        this.x /= scalar;
        this.y /= scalar;
        this.z /= scalar;
        this.length /= scalar;
    }

    public static Vector3D sub(Vector3D v, Vector3D u) {
        return new Vector3D(v.x - u.x, v.y - u.y, v.z - u.z);
    }

    public void sub(Vector3D u) {
        this.x -= u.x;
        this.y -= u.y;
        this.z -= u.z;
        this.isChanged = true;
    }

    public static Vector3D add(Vector3D v, Vector3D u) {
        return new Vector3D(v.x + u.x, v.y + u.y, v.z + u.z);
    }

    public void add(Vector3D v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        this.isChanged = true;
    }

    public static Vector3D mirror(Vector3D v, Vector3D n) {
        Vector3D u = Vector3D.project(v, n);
        return Vector3D.sub(v, Vector3D.scalarMul(2.0f, u));
    }

    public static Vector3D reverse(Vector3D v) {
        return new Vector3D(-v.x, -v.y, -v.z);
    }

    public void reverse() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public float FBdir(Vector3D in) {
        float ulen = Math.max(1.0E-4f, this.length());
        float vlen = Math.max(1.0E-4f, in.length());
        float ux = this.x / ulen;
        float uz = this.z / ulen;
        float vx = in.x / vlen;
        float vz = in.z / vlen;
        return ux * vx + uz * vz;
    }

    public boolean isFdir(Vector3D in) {
        return this.x * in.x + this.z * in.z >= 0.0f;
    }

    public float LRdir(Vector3D in) {
        float ulen = Math.max(1.0E-4f, this.length());
        float vlen = Math.max(1.0E-4f, in.length());
        float ux = this.x / ulen;
        float uz = this.z / ulen;
        float vx = in.x / vlen;
        float vz = in.z / vlen;
        return ux * vz - uz * vx;
    }

    public int LRdirSign(Vector3D in) {
        if (this.x * in.z - this.z * in.x > 0.0f) {
            return 1;
        }
        if (this.x * in.z - this.z * in.x < 0.0f) {
            return -1;
        }
        return 0;
    }
}

