/*
 * Decompiled with CFR 0.152.
 */
package tinbrain.math3d;

import tinbrain.GCanvas;
import tinbrain.math3d.Bezier4;
import tinbrain.math3d.Point2D;

public final class AutoBezier {
    private Point2D[] mPoints;
    private int[] mLengths;
    public int mNumSegments;
    private int mTotalLength;
    private int mSmoothness;
    private boolean mLooping;
    private static Bezier4 mBezier = new Bezier4();

    public AutoBezier(int n, boolean bl) {
        this.mSmoothness = n;
        this.mLooping = bl;
    }

    public final void initBlank(int n) {
        if (n < 2) {
            return;
        }
        int n2 = n * 3;
        this.mPoints = new Point2D[n2];
        this.mNumSegments = n - 1;
        if (this.mLooping) {
            ++this.mNumSegments;
        }
        this.mLengths = new int[this.mNumSegments];
        for (int i = 0; i < n2; ++i) {
            this.mPoints[i] = new Point2D();
        }
    }

    public final void setPoint(int n, int n2, int n3) {
        this.mPoints[1 + n * 3].set(n2, n3);
    }

    public final void calculateWeights() {
        int n = this.mNumSegments + 1;
        int n2 = this.mPoints.length;
        if (n < 2) {
            return;
        }
        int n3 = this.mSmoothness;
        Point2D point2D = Point2D.getLocal();
        Point2D point2D2 = Point2D.getLocal();
        Point2D point2D3 = Point2D.getLocal();
        for (int i = 0; i < n; ++i) {
            int n4 = GCanvas.mathModWrap(1 + i * 3, 0, n2);
            point2D2.setDiff(this.mPoints[GCanvas.mathModWrap(n4 + 3, 0, n2)], this.mPoints[n4]);
            point2D3.setDiff(this.mPoints[GCanvas.mathModWrap(n4 - 3, 0, n2)], this.mPoints[n4]);
            point2D.setDiff(point2D2, point2D3);
            this.mPoints[GCanvas.mathModWrap(n4 + 1, 0, n2)].set(this.mPoints[n4]);
            this.mPoints[GCanvas.mathModWrap(n4 + 1, 0, n2)].addScaled(point2D, n3);
            point2D.setDiff(point2D3, point2D2);
            this.mPoints[GCanvas.mathModWrap(n4 - 1, 0, n2)].set(this.mPoints[n4]);
            this.mPoints[GCanvas.mathModWrap(n4 - 1, 0, n2)].addScaled(point2D, n3);
        }
        if (!this.mLooping) {
            point2D.setDiff(this.mPoints[4], this.mPoints[1]);
            point2D.scale(n3);
            this.mPoints[2].set(this.mPoints[1]);
            this.mPoints[2].add(point2D);
            point2D.setDiff(this.mPoints[n2 - 5], this.mPoints[n2 - 2]);
            point2D.scale(n3);
            this.mPoints[n2 - 3].set(this.mPoints[n2 - 2]);
            this.mPoints[n2 - 3].add(point2D);
        }
        this.calcTotalLength();
        Point2D.freeLocal(point2D3);
        Point2D.freeLocal(point2D2);
        Point2D.freeLocal(point2D);
    }

    private void calcTotalLength() {
        Point2D point2D = Point2D.getLocal();
        this.mTotalLength = 0;
        for (int i = 0; i < this.mNumSegments; ++i) {
            int n = 1 + i * 3;
            point2D.setDiff(this.mPoints[n + 1], this.mPoints[n]);
            this.mLengths[i] = point2D.length();
            point2D.setDiff(this.mPoints[GCanvas.mathModWrap(n + 2, 0, this.mPoints.length)], this.mPoints[n + 1]);
            int n2 = i;
            this.mLengths[n2] = this.mLengths[n2] + point2D.length();
            point2D.setDiff(this.mPoints[GCanvas.mathModWrap(n + 3, 0, this.mPoints.length)], this.mPoints[GCanvas.mathModWrap(n + 2, 0, this.mPoints.length)]);
            int n3 = i;
            this.mLengths[n3] = this.mLengths[n3] + point2D.length();
            this.mTotalLength += this.mLengths[i];
        }
        Point2D.freeLocal(point2D);
    }

    public final void getPoint2D(int n, Point2D point2D) {
        int n2 = this.mNumSegments;
        n2 = (n2 << 10) - 1;
        n = Math.min(n, n2);
        n = Math.max(n, 0);
        int n3 = n >> 10;
        int n4 = 1 + n3 * 3;
        mBezier.init(this.mPoints[n4], this.mPoints[n4 + 1], this.mPoints[GCanvas.mathModWrap(n4 + 2, 0, this.mPoints.length)], this.mPoints[GCanvas.mathModWrap(n4 + 3, 0, this.mPoints.length)]);
        mBezier.getPoint2D(n &= 0x3FF, point2D);
    }
}

