/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Game;
import game.GameSprite;
import game.Weapon;
import game.dirtfield.DirtFieldBase;
import javax.microedition.lcdui.Graphics;
import tinbrain.GCanvas;
import tinbrain.RM;

public final class Tank {
    public String name;
    public int tankid = -1;
    public int controller;
    public GameSprite body = null;
    public GameSprite barrel = null;
    private int barrelAnchorX;
    private int barrelAnchorY;
    public int health;
    private int selectedWeapon;
    private int shotQuotesStart;
    private int shotQuotesEnd;
    private int killQuotesStart;
    private int killQuotesEnd;
    private int deathQuotesStart;
    private int deathQuotesEnd;
    public int angle;
    public int x;
    public int y;
    public int style;
    public int cash;
    public int wins;
    public int kills;
    public int deaths;
    public boolean hitThisFrame;
    public boolean healthVisible;
    private Weapon death;
    private boolean mCpuShot;
    public int[] mWeapons;
    public int[] mWeaponCounts;
    private boolean mIsTitleScreenTank;
    private int mTitleScreenTankFrameCount;
    public boolean falling;
    public int mColorMask;
    private int[] cpumove_angles = new int[96];
    private int[] cpumove_subAngles = new int[96];

    public final int logicalWidth() {
        return this.body.logicalWidth;
    }

    public final int logicalHeight() {
        return this.body.logicalHeight;
    }

    public final int getNextWeapon(int n) {
        for (int i = n + 1; i < this.mWeapons.length; ++i) {
            if (this.mWeapons[i] < 0) continue;
            return i;
        }
        return -1;
    }

    public final void setWeapon(int n, int n2) {
        int n3;
        for (n3 = 0; n3 < this.mWeapons.length; ++n3) {
            if (this.mWeapons[n3] != n) continue;
            this.mWeaponCounts[n3] = n2;
            return;
        }
        n3 = this.getFreeWeaponSlot();
        this.mWeapons[n3] = n;
        this.mWeaponCounts[n3] = n2;
    }

    public final int getSelectedWeaponKey() {
        return this.mWeapons[this.selectedWeapon];
    }

    public final int getWeaponAmmo(int n) {
        for (int i = 0; i < this.mWeapons.length; ++i) {
            if (this.mWeapons[i] != n) continue;
            return this.mWeaponCounts[i];
        }
        return 0;
    }

    public final int getSelectedWeaponAmmo() {
        return this.mWeaponCounts[this.selectedWeapon];
    }

    public final int getBarrelX() {
        int n = this.barrel.angle;
        int n2 = -Game.instance.gamefield_dirtField.dirtFieldToLogicalY(Game.instance.mSpriteRenderer$6be6c80c.getRefY(this.barrel.id));
        return this.body.x + ((n2 + this.barrel.logicalHeight) * Game.fastSin(n) >> 10);
    }

    public final int getBarrelY() {
        int n = this.barrel.angle;
        int n2 = -Game.instance.gamefield_dirtField.dirtFieldToLogicalY(Game.instance.mSpriteRenderer$6be6c80c.getRefY(this.barrel.id));
        return this.body.y - ((n2 + this.barrel.logicalHeight) * Game.fastCos(n) >> 10);
    }

    private static int computedBarrelAnchorX() {
        return 0;
    }

    private int computedBarrelAnchorY() {
        int n = this.body.angle;
        return Game.fastSin(n) * this.barrelAnchorX + Game.fastCos(n) * this.barrelAnchorY >> 10;
    }

    public final void applyDamage(int n, Tank tank) {
        if (this.mIsTitleScreenTank) {
            return;
        }
        if (this.health > 0) {
            if (tank != this && tank != null) {
                tank.cash += Math.min(this.health, n) * Game.instance.getRuleValueInt(13);
            }
            this.health -= n;
            if (this.health <= 0) {
                this.explode();
                ++this.deaths;
                if (tank != this && tank != null) {
                    ++tank.kills;
                    tank.cash += Game.instance.getRuleValueInt(12);
                    if (this.killQuotesStart != -1 && !Game.instance.quote_active(this)) {
                        tank.say(GCanvas.getRandom(this.killQuotesStart, this.killQuotesEnd));
                    }
                }
            }
        }
    }

    private void explode() {
        if (this.deathQuotesStart != -1 && GCanvas.getRandom(0, 1024) < 512) {
            this.say(GCanvas.getRandom(this.deathQuotesStart, this.deathQuotesEnd));
        }
        this.death = Weapon.weapons_createWeapon(42);
        this.death.x = this.x;
        this.death.y = this.y - this.body.logicalHeight / 2;
        this.death.explode();
    }

    public final boolean isFinished() {
        return this.health <= 0 && this.death.isFinished() && !Game.instance.quote_active(this);
    }

    public final void nextWeapon() {
        do {
            ++this.selectedWeapon;
            if (this.selectedWeapon < this.mWeapons.length) continue;
            this.selectedWeapon = 0;
        } while (this.mWeaponCounts[this.selectedWeapon] == 0);
    }

    public final void previousWeapon() {
        do {
            --this.selectedWeapon;
            if (this.selectedWeapon >= 0) continue;
            this.selectedWeapon = this.mWeapons.length - 1;
        } while (this.mWeaponCounts[this.selectedWeapon] == 0);
    }

    public final void reset() {
        this.health = Game.instance.getRuleValueInt(1);
        Game.instance.quote_reset(this);
        this.adjustHeightAndAngleForDirtField(Game.instance.gamefield_dirtField);
        for (int i = 0; i < this.mWeapons.length; ++i) {
            if (this.mWeapons[i] != 41) continue;
            this.mWeaponCounts[i] = Game.instance.getRuleValueInt(14);
            return;
        }
    }

    public final void resetWeapons() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.mWeaponCounts.length; ++n2) {
            this.mWeaponCounts[n2] = 0;
            this.mWeapons[n2] = -1;
        }
        for (n2 = Game.instance.getRuleValueInt(16); n2 <= Game.instance.getRuleValueInt(17); ++n2) {
            int n3 = RM.getValue(82, n2, 2);
            if (n3 != 0) continue;
            n = this.getFreeWeaponSlot();
            this.mWeapons[n] = n2;
            this.mWeaponCounts[n] = -1;
        }
        n2 = Game.instance.getRuleValueInt(14);
        if (n2 > 0) {
            n = this.getFreeWeaponSlot();
            this.mWeapons[n] = 41;
            this.mWeaponCounts[n] = n2;
        }
        this.selectedWeapon = 0;
    }

    private void say(int n) {
        this.say(n, "", "");
    }

    private void say(int n, String string, String string2) {
        Game game = Game.instance;
        if (!(game.quote_active(this) || this.controller == 1 && game.getRuleValueInt(6) != 1)) {
            if (RM.isVarText(n)) {
                RM.prepareVarText(n, string2, string);
            }
            game.quote_addQuote(n, this.x, this.y, this);
        }
    }

    public final void activate() {
        int n = this.mWeaponCounts[this.selectedWeapon];
        if (n == 0) {
            this.mWeapons[this.selectedWeapon] = -1;
        }
        if (this.selectedWeapon >= this.mWeapons.length) {
            this.selectedWeapon = 0;
        }
    }

    private void setBodyAngle(int n) {
        if (n != this.body.angle) {
            this.body.angle = n;
            this.setAngle(n);
            this.barrel.x = this.x + Tank.computedBarrelAnchorX();
            this.barrel.y = this.y + this.computedBarrelAnchorY();
        }
    }

    public final void adjustHeightAndAngleForDirtField(DirtFieldBase dirtFieldBase) {
        this.setY(dirtFieldBase.getGroundLevel(this.x));
        this.setBodyAngle(dirtFieldBase.getAngle(this.x));
    }

    private void adjustHeightAndAngleForDirtField(int n, int n2) {
        this.setY(n);
        this.setBodyAngle(n2);
    }

    public final boolean driveLeft() {
        int n = 102400 / GCanvas.getWidth();
        if (this.x - n < 0) {
            return false;
        }
        this.setX(this.x - n);
        DirtFieldBase dirtFieldBase = Game.instance.gamefield_dirtField;
        int n2 = dirtFieldBase.getAngle(this.x);
        int n3 = dirtFieldBase.getGroundLevel(this.x);
        if (this.y - n3 > 2048) {
            this.setX(this.x + n);
            return false;
        }
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        this.getBounds(nArray);
        nArray[3] = nArray[1] + (nArray[3] - nArray[1] >> 1);
        nArray[1] = n3 - this.body.logicalHeight;
        Object[] objectArray = Game.instance.gamestate_players;
        int n4 = Game.count(Game.instance.gamestate_players);
        for (int i = 0; i < n4; ++i) {
            Object object = objectArray[i];
            if (object == this || ((Tank)object).health <= 0) continue;
            super.getBounds(nArray2);
            if (!RM.intersects(nArray, nArray2)) continue;
            this.setX(this.x + n);
            return false;
        }
        this.setY(n3);
        this.setBodyAngle(n2);
        return true;
    }

    public final boolean driveRight() {
        DirtFieldBase dirtFieldBase = Game.instance.gamefield_dirtField;
        int n = 102400 / GCanvas.getWidth();
        if (this.x + n > dirtFieldBase.mWidth) {
            return false;
        }
        this.setX(this.x + n);
        int n2 = dirtFieldBase.getAngle(this.x);
        int n3 = dirtFieldBase.getGroundLevel(this.x);
        if (this.y - n3 > 2048) {
            this.setX(this.x - n);
            return false;
        }
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        this.getBounds(nArray);
        nArray[3] = nArray[1] + (nArray[3] - nArray[1] >> 1);
        nArray[1] = n3 - this.body.logicalHeight;
        Object[] objectArray = Game.instance.gamestate_players;
        int n4 = Game.count(Game.instance.gamestate_players);
        for (int i = 0; i < n4; ++i) {
            Object object = objectArray[i];
            if (object == this || ((Tank)object).health <= 0) continue;
            super.getBounds(nArray2);
            if (!RM.intersects(nArray, nArray2)) continue;
            this.setX(this.x - n);
            return false;
        }
        this.setY(n3);
        this.setBodyAngle(n2);
        return true;
    }

    public final boolean cpuMove() {
        if (this.mIsTitleScreenTank) {
            return this.titlescreentank_cpuMove();
        }
        Game game = Game.instance;
        if (game.gamefield_isReady()) {
            int n;
            int n2;
            if (this.mCpuShot) {
                this.mCpuShot = false;
                return true;
            }
            Tank tank = this.selectTarget();
            if (tank == null) {
                return true;
            }
            int n3 = tank.x;
            int n4 = (3 - game.gamestate_difficulty << 10) / 3;
            n3 += (n4 *= 100) / 2 - (GCanvas.getRandom(0, 1024) * n4 >> 10);
            int n5 = 0;
            boolean bl = false;
            int n6 = 0;
            int n7 = 0;
            for (n2 = -30; n2 <= 30; n2 += 4) {
                this.cpumove_subAngles[n6++] = n2;
            }
            GCanvas.shuffle(this.cpumove_subAngles);
            for (n = 0; n < n6; ++n) {
                this.cpumove_angles[n7++] = this.cpumove_subAngles[n];
            }
            for (n2 = -60; n2 <= -30; n2 += 4) {
                this.cpumove_subAngles[n6++] = n2;
            }
            for (n2 = 30; n2 <= 60; n2 += 4) {
                this.cpumove_subAngles[n6++] = n2;
            }
            GCanvas.shuffle(this.cpumove_subAngles);
            for (n = 0; n < n6; ++n) {
                this.cpumove_angles[n7++] = this.cpumove_subAngles[n];
            }
            for (n2 = -90; n2 <= -60; n2 += 4) {
                this.cpumove_subAngles[n6++] = n2;
            }
            for (n2 = 60; n2 <= 90; n2 += 4) {
                this.cpumove_subAngles[n6++] = n2;
            }
            GCanvas.shuffle(this.cpumove_subAngles);
            for (n = 0; n < n6; ++n) {
                this.cpumove_angles[n7++] = this.cpumove_subAngles[n];
            }
            block8: for (n2 = 0; n2 < n7 && !bl; ++n2) {
                this.setAngle(this.cpumove_angles[n2] - this.body.angle);
                int n8 = n5 = 0;
                while (n8 < 10240000) {
                    int n9 = this.simulateShotWithPower(n5, tank);
                    if (Math.abs(n9 - n3) < tank.body.logicalWidth / 3) {
                        bl = true;
                        continue block8;
                    }
                    n8 = n5 + 102400;
                }
            }
            do {
                this.selectedWeapon = this.getRandomWeapon();
            } while (this.mWeapons[this.selectedWeapon] == 41);
            this.fireWithPower(n5);
            this.mCpuShot = true;
            return false;
        }
        return false;
    }

    public final int getNumWeapons() {
        int n = 0;
        for (int i = 0; i < this.mWeapons.length; ++i) {
            if (this.mWeapons[i] == -1) continue;
            ++n;
        }
        return n;
    }

    private int getRandomWeapon() {
        int n = GCanvas.getRandom(0, this.getNumWeapons());
        for (int i = 0; i < this.mWeapons.length; ++i) {
            if (this.mWeapons[i] == -1) continue;
            if (n == 0) {
                return i;
            }
            --n;
        }
        return -1;
    }

    public final void init() {
        this.controller = 1;
        this.setStyle(GCanvas.getRandom(0, 4));
        this.health = Game.instance.getRuleValueInt(1);
        this.cash = Game.instance.getRuleValueInt(9);
        this.wins = 0;
        this.kills = 0;
        if (this.mWeapons == null) {
            this.mWeapons = new int[52];
        }
        for (int i = 0; i < this.mWeapons.length; ++i) {
            this.mWeapons[i] = -1;
        }
        if (this.mWeaponCounts == null) {
            this.mWeaponCounts = new int[52];
        }
        this.resetWeapons();
        this.setAngle(90);
    }

    /*
     * Unable to fully structure code
     */
    public final void setStyle(int var1_1) {
        this.style = var1_1;
        switch (this.style) {
            case 0: {
                this.body = new GameSprite(0);
                this.barrel = new GameSprite(1);
                this.barrelAnchorX = 18 * this.body.logicalWidth / 100;
                v0 = this;
                v1 = -70;
                ** GOTO lbl28
            }
            case 1: {
                this.body = new GameSprite(2);
                v2 = this;
                v3 = new GameSprite(3);
                ** GOTO lbl24
            }
            case 2: {
                this.body = new GameSprite(4);
                v2 = this;
                v3 = new GameSprite(5);
                ** GOTO lbl24
            }
            case 3: {
                this.body = new GameSprite(6);
                v2 = this;
                v3 = new GameSprite(7);
lbl24:
                // 3 sources

                v2.barrel = v3;
                this.barrelAnchorX = 12 * this.body.logicalWidth / 100;
                v0 = this;
                v1 = -80;
lbl28:
                // 2 sources

                v0.barrelAnchorY = v1 * this.body.logicalHeight / 100;
            }
        }
        this.barrelAnchorX = 0;
        this.body.x = this.x;
        this.body.y = this.y;
        this.barrel.x = this.x + Tank.computedBarrelAnchorX();
        this.barrel.y = this.y + this.computedBarrelAnchorY();
        this.setAngle(this.angle);
    }

    public final void setX(int n) {
        this.body.x = this.x = n;
        this.barrel.x = this.x + Tank.computedBarrelAnchorX();
    }

    private void setY(int n) {
        this.body.y = this.y = n;
        this.barrel.y = this.y + Tank.computedBarrelAnchorX();
    }

    public final void setAngle(int n) {
        this.angle = n;
        this.barrel.angle = n + this.body.angle;
    }

    public final void setName(int n) {
        this.name = RM.t(n);
    }

    public final void initQuotes(int n) {
        this.tankid = n;
        if (n == -1) {
            this.deathQuotesEnd = -1;
            this.deathQuotesStart = -1;
            this.killQuotesEnd = -1;
            this.killQuotesStart = -1;
            this.shotQuotesEnd = -1;
            this.shotQuotesStart = -1;
            return;
        }
        int n2 = RM.getValue(84, n, 2);
        int n3 = RM.getValue(84, n, 3);
        int n4 = RM.getValue(84, n, 4);
        int n5 = RM.getValue(84, n, 0);
        this.shotQuotesStart = n5 + 1;
        this.killQuotesStart = this.shotQuotesEnd = this.shotQuotesStart + n2;
        this.deathQuotesStart = this.killQuotesEnd = this.killQuotesStart + n3;
        this.deathQuotesEnd = this.deathQuotesStart + n4;
    }

    public final boolean isSolid(int n, int n2) {
        if (this.health <= 0) {
            return false;
        }
        int n3 = this.body.logicalWidth >> 1;
        return n > this.x - n3 && n < this.x + n3 && n2 > this.y - this.body.logicalHeight && n2 < this.y;
    }

    private void renderHealth(Graphics graphics) {
        DirtFieldBase dirtFieldBase = Game.instance.gamefield_dirtField;
        int n = 20 * this.health / Game.instance.getRuleValueInt(1);
        int n2 = dirtFieldBase.logicalToScreenX(this.x);
        int n3 = dirtFieldBase.logicalToScreenY(this.y) - 20;
        int n4 = 0;
        n4 = GCanvas.getFontHeight(1);
        if (n3 < n4) {
            n3 += 30;
        }
        graphics.setColor(0);
        graphics.fillRect(n2 - 10, n3, 20, 2);
        graphics.setColor(0xCC1919);
        graphics.fillRect(n2 - 10, n3, n, 2);
    }

    private void renderNameTag(Graphics graphics) {
        DirtFieldBase dirtFieldBase = Game.instance.gamefield_dirtField;
        int n = dirtFieldBase.logicalToScreenX(this.x);
        int n2 = dirtFieldBase.logicalToScreenY(this.y);
        int n3 = GCanvas.getStringWidth(this.name, 1);
        int n4 = GCanvas.getFontHeight(1);
        int n5 = n3 + 6;
        int n6 = n4 + 4;
        int n7 = 0;
        n7 = GCanvas.getFontHeight(1) + n6 / 2;
        n2 = n2 - 35 < n7 ? n2 + (35 - n6 / 2) : n2 - 35;
        graphics.setColor(-16764928);
        int n8 = n - (n3 >> 1) - 3;
        int n9 = n2 - (n4 >> 1) - 2;
        GCanvas.fillRectWithImage(graphics, 35, n8, n9, n8 + n5, n9 + n6);
        graphics.setColor(-16744448);
        graphics.drawRect(n8, n9, n5, n6);
        GCanvas.drawString(graphics, 1, this.name, n, n2, 3);
    }

    private boolean showActiveBadge() {
        return !this.mIsTitleScreenTank && Game.instance.gamestate_currentPlayer() == this;
    }

    public final void render(Graphics graphics) {
        if (this.health > 0) {
            this.barrel.x = this.body.x;
            this.barrel.y = this.body.y;
            this.barrel.render$417dcfd4(this.mColorMask);
            this.body.render$417dcfd4(this.mColorMask);
            return;
        }
        this.death.render(graphics);
    }

    public final void renderPostChrome(Graphics graphics) {
        if (this.health > 0) {
            if (this.healthVisible) {
                this.renderHealth(graphics);
            }
            if (this.showActiveBadge()) {
                this.renderNameTag(graphics);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void update() {
        DirtFieldBase dirtFieldBase = Game.instance.gamefield_dirtField;
        this.hitThisFrame = false;
        if (this.health <= 0) {
            this.death.update();
            return;
        }
        int n = dirtFieldBase.getGroundLevel(this.x);
        int n2 = dirtFieldBase.getAngle(this.x);
        if (this.y < n) {
            if (this.y >= n) return;
            this.setY(this.y + dirtFieldBase.dirtFieldToLogicalY(1));
            return;
        }
        if (this.y - n < 3072 / GCanvas.getHeight()) {
            this.adjustHeightAndAngleForDirtField(n, n2);
        }
        this.falling = false;
    }

    public final void fireWithPower(int n) {
        if (this.shotQuotesStart != -1 && GCanvas.getRandom(0, 1024) < 256) {
            this.say(GCanvas.getRandom(this.shotQuotesStart, this.shotQuotesEnd));
        }
        int n2 = this.getBarrelX();
        int n3 = this.getBarrelY();
        Game game = Game.instance;
        ++game.gamestate_spawnedWeapons;
        int n4 = this.mWeapons[this.selectedWeapon];
        Weapon weapon = Weapon.weapons_createWeapon(n4);
        Weapon.weapons_createWeapon(n4).source = this;
        Game.instance.gamefield_addWeapon(weapon);
        int n5 = this.barrel.angle;
        weapon.fire(n2, n3, n5, n);
        game.sfxPlayLogicSound(weapon.mLaunchSound, 0);
        int n6 = this.mWeaponCounts[this.selectedWeapon];
        if (n6 >= 1) {
            int n7 = this.selectedWeapon;
            this.mWeaponCounts[n7] = this.mWeaponCounts[n7] - 1;
        }
    }

    private void getBounds(int[] nArray) {
        RM.setRect(nArray, this.x - (this.body.logicalWidth >> 1), this.y - this.body.logicalHeight, this.body.logicalWidth, this.body.logicalHeight);
    }

    private int simulateShotWithPower(int n, Tank tank) {
        int n2 = this.getBarrelX();
        int n3 = this.getBarrelY();
        int n4 = this.barrel.angle;
        long l = ((long)Game.fastSin(n4) * (long)n >> 10) / 4096L;
        long l2 = tank.y - tank.body.logicalHeight / 2;
        boolean bl = false;
        for (long i = (-((long)Game.fastCos(n4)) * (long)n >> 10) / 4096L; i < 0L || (long)n3 < l2; i += (long)Game.instance.gamestate_gravity) {
            n2 = (int)((long)n2 + l);
            if ((long)(n3 = (int)((long)n3 + i)) < l2) {
                bl = true;
            }
            l += (long)Game.instance.gamestate_wind;
        }
        if (bl) {
            return n2;
        }
        return -10240;
    }

    private Tank selectTarget() {
        Object object;
        int n = 0;
        Object[] objectArray = Game.instance.gamefield_tanks;
        int n2 = Game.count(Game.instance.gamefield_tanks);
        for (int i = 0; i < n2; ++i) {
            if (((Tank)objectArray[i]).health <= 0) continue;
            ++n;
        }
        if (n <= 1) {
            return null;
        }
        while ((object = objectArray[GCanvas.getRandom(0, n2)]) == this || ((Tank)object).health <= 0) {
        }
        return object;
    }

    public final void setSelectedWeaponAmmo(int n) {
        this.mWeaponCounts[this.selectedWeapon] = n;
    }

    private int getFreeWeaponSlot() {
        for (int i = 0; i < this.mWeapons.length; ++i) {
            if (this.mWeapons[i] != -1) continue;
            return i;
        }
        return -1;
    }

    public final void buy(int n) {
        int n2 = Tank.getWeaponPrice(n);
        if (this.cash >= n2) {
            int n3;
            this.cash -= n2;
            for (n3 = 0; n3 < this.mWeapons.length; ++n3) {
                if (this.mWeapons[n3] != n) continue;
                int n4 = n3;
                this.mWeaponCounts[n4] = this.mWeaponCounts[n4] + 1;
                return;
            }
            n3 = this.getFreeWeaponSlot();
            this.mWeapons[n3] = n;
            this.mWeaponCounts[n3] = 1;
        }
    }

    public final void sell(int n) {
        for (int i = 0; i < this.mWeapons.length; ++i) {
            if (this.mWeapons[i] != n) continue;
            int n2 = this.mWeaponCounts[i];
            if (n2 < 1) break;
            this.cash += Tank.getWeaponPrice(n) * 768 >> 10;
            if (n2 > 1) {
                int n3 = i;
                this.mWeaponCounts[n3] = this.mWeaponCounts[n3] - 1;
                return;
            }
            this.mWeaponCounts[i] = 0;
            this.mWeapons[i] = -1;
            return;
        }
    }

    public static void shopCPU() {
        Tank[] tankArray = Game.instance.gamestate_players;
        block0: for (int i = 0; i < tankArray.length; ++i) {
            Tank tank = tankArray[i];
            if (tank == null || tank.controller != 1) continue;
            int[] nArray = new int[5];
            while (true) {
                int n = 0;
                int n2 = Game.instance.getRuleValueInt(16);
                int n3 = Game.instance.getRuleValueInt(17);
                for (int j = n2; j <= n3; ++j) {
                    int n4 = RM.getValue(82, j, 2);
                    if (n4 > tank.cash || n4 <= 0) continue;
                    nArray[n++] = j;
                    if (n == nArray.length) break;
                }
                if (n == 0) continue block0;
                tank.buy(nArray[GCanvas.getRandom(0, n)]);
            }
        }
    }

    private static int getWeaponPrice(int n) {
        if (n == 41) {
            return -1;
        }
        if (n == 40) {
            return -1;
        }
        return RM.getValue(82, n, 2);
    }

    public final void titlescreentank_init() {
        this.init();
        this.initQuotes(-1);
        this.mColorMask = -1;
        this.mIsTitleScreenTank = true;
        int n = this.getFreeWeaponSlot();
        this.mWeapons[n] = 43;
        this.mWeaponCounts[n] = -1;
        this.selectedWeapon = n;
    }

    private boolean titlescreentank_cpuMove() {
        if (++this.mTitleScreenTankFrameCount >= 3) {
            this.setAngle(GCanvas.getRandom(-90, 90));
            int n = GCanvas.getRandom(0, 10240000);
            this.fireWithPower(n);
            this.mTitleScreenTankFrameCount = 0;
            return true;
        }
        return false;
    }
}

