/*
 * Decompiled with CFR 0.152.
 */
package game.dirtfield;

import game.Game;
import game.dirtfield.DirtFieldBase;
import javax.microedition.lcdui.Graphics;
import tinbrain.GCanvas;
import tinbrain.RM;
import tinbrain.math3d.AutoBezier;
import tinbrain.math3d.Point2D;

public final class DirtField_RGBBuffer
extends DirtFieldBase {
    private int[] mField;
    private short[] mScanHeight;
    private int mGroundTexture;
    private int mWallTexture;

    public final void init(int n, int n2) {
        this.allocCachedHeights(n);
        super.init(n, n2);
        this.mField = new int[n * n2];
        this.mWallTexture = 36;
        this.mScanHeight = new short[this.mPixelWidth];
    }

    private void reset() {
        for (int i = 0; i < this.mScanHeight.length; ++i) {
            this.mScanHeight[i] = (short)(this.mPixelHeight - 1);
        }
        this.initCachedHeights();
    }

    public final void addClodAtColumn(int n, int n2, int n3, int n4) {
        int n5;
        if (n < 0 || n >= this.mPixelWidth) {
            return;
        }
        int n6 = this.getCachedGroundLevelForColumn(n - 1);
        int n7 = this.getCachedGroundLevelForColumn(n);
        int n8 = this.getCachedGroundLevelForColumn(n + 1);
        if (n6 > n7 && n6 >= n8) {
            --n;
            n5 = n6;
        } else if (n8 > n7 && n8 >= n6) {
            ++n;
            n5 = n8;
        } else {
            n5 = n7;
        }
        int n9 = n5 - 1;
        if (n9 >= 0) {
            int n10 = n9 * this.mPixelWidth + n;
            this.mField[n10] = (n2 & 0xFF) << 16 | (n3 & 0xFF) << 8 | (n4 & 0xFF) << 0 | 0xFF000000;
        }
    }

    public final void createCircle(int n, int n2, int n3) {
        int[] nArray = this.mField;
        int n4 = RM.getWidth(this.mWallTexture);
        int n5 = RM.getHeight(this.mWallTexture);
        int[] nArray2 = RM.getInts(this.mWallTexture);
        DirtFieldBase.checkForFallingTanks(n, n3);
        int n6 = this.logicalToDirtFieldX(n);
        int n7 = this.logicalToDirtFieldY(n2);
        int n8 = this.logicalToDirtFieldX(n3);
        int n9 = Math.max(0, n6 - n8);
        int n10 = Math.min(this.mPixelWidth - 1, n6 + n8);
        int n11 = Math.max(0, n7 - n8);
        int n12 = Math.min(this.mPixelHeight - 1, n7 + n8);
        int n13 = n12 * this.mPixelWidth + n9;
        for (int i = n9; i <= n10; ++i) {
            boolean bl = false;
            int n14 = n13;
            for (int j = n12; j >= n11; --j) {
                int n15 = i - n6;
                int n16 = j - n7;
                int n17 = GCanvas.sqrt(n15 * n15 + n16 * n16 << 10) >> 10;
                if (n17 < n8) {
                    int n18;
                    this.mCachedHeights[i] = (short)Math.min(j, this.mCachedHeights[i]);
                    if (!bl) {
                        bl = true;
                        if (j < this.mPixelHeight - 1 && (nArray[n14 + this.mPixelWidth] & 0xFF000000) == 0) {
                            for (n18 = j + 1; n18 < this.mPixelHeight; ++n18) {
                                if ((nArray[n18 * this.mPixelWidth + i] & 0xFF000000) == 0) continue;
                                this.mScanHeight[i] = (short)Math.max(this.mScanHeight[i], n18 - 1);
                                break;
                            }
                        }
                    }
                    if ((nArray[n14] & 0xFF000000) == 0) {
                        n18 = i % n4 + j % n5 * n4;
                        nArray[n14] = 0xFF000000 | nArray2[n18];
                    }
                }
                n14 -= this.mPixelWidth;
            }
            ++n13;
        }
    }

    public final void createSplineLandscape() {
        int n;
        int n2;
        int n3;
        int n4;
        AutoBezier autoBezier = this.setupSpline();
        this.clear();
        int n5 = 0;
        int n6 = 0;
        int n7 = autoBezier.mNumSegments;
        this.mGroundTexture = GCanvas.getRandom(Game.instance.getRuleValueInt(20), Game.instance.getRuleValueInt(21));
        int n8 = RM.getWidth(this.mGroundTexture);
        int n9 = RM.getHeight(this.mGroundTexture);
        int[] nArray = RM.getInts(this.mGroundTexture);
        int[] nArray2 = this.mField;
        int n10 = 0;
        Point2D point2D = new Point2D();
        for (n4 = 0; n4 < n7 + 1 << 10; n4 += 10) {
            autoBezier.getPoint2D(n4, point2D);
            if (point2D.x >= n5) {
                n6 = Math.max(0, Math.min(point2D.y, this.mPixelHeight - 1));
                n10 = point2D.y;
            } else {
                n6 = n10;
            }
            if (point2D.x >= 0 && point2D.x < this.mPixelWidth) {
                for (n3 = n5; n3 < point2D.x; ++n3) {
                    n2 = n6 * this.mPixelWidth + n3;
                    n = 0;
                    while (n < this.mPixelHeight - n6) {
                        int n11 = n3 % n8 + n % n9 * n8;
                        nArray2[n2] = 0xFF000000 | nArray[n11];
                        ++n;
                        n2 += this.mPixelWidth;
                    }
                }
            }
            n5 = point2D.x;
        }
        for (n4 = n5; n4 < this.mPixelWidth; ++n4) {
            n3 = n6 * this.mPixelWidth + n4;
            n2 = 0;
            while (n2 < this.mPixelHeight - n6) {
                n = n4 % n8 + n2 % n9 * n8;
                nArray2[n3] = 0xFF000000 | nArray[n];
                ++n2;
                n3 += this.mPixelWidth;
            }
        }
        this.reset();
    }

    public final void loadLandscapeFromFile(int n) {
        int n2 = RM.getWidth(n);
        int n3 = RM.getHeight(n);
        this.clear();
        int n4 = this.mPixelHeight * 80 / 100;
        int n5 = Math.max(0, n4 - n3) + Math.max(0, this.mPixelHeight - n4);
        int n6 = n5 * this.mPixelWidth;
        int n7 = 0 * n2;
        if (n2 != this.mPixelWidth) {
            short[] sArray = RM.getShorts(n);
            int n8 = Math.min(n3, n4);
            for (int i = 0; i < n8; ++i) {
                int n9 = Math.max(0, n2 - this.mPixelWidth >> 1);
                int n10 = Math.max(0, this.mPixelWidth - n2 >> 1);
                int n11 = Math.min(n2, this.mPixelWidth);
                int n12 = n7 + n9;
                int n13 = n6 + n10;
                for (int j = 0; j < n11; ++j) {
                    short s = sArray[n12++];
                    int n14 = (s & 0xF000) << 16 | (s & 0xF00) << 12 | (s & 0xF0) << 8 | (s & 0xF) << 4;
                    this.mField[n13++] = n14 | n14 >> 4;
                }
                n6 += this.mPixelWidth;
                n7 += n2;
            }
        } else {
            int n15 = Math.min(n2, this.mPixelWidth) * Math.min(n3, n4);
            short[] sArray = RM.getShorts(n);
            for (int i = 0; i < n15; ++i) {
                short s = sArray[n7++];
                int n16 = (s & 0xF000) << 16 | (s & 0xF00) << 12 | (s & 0xF0) << 8 | (s & 0xF) << 4;
                this.mField[n6++] = n16 | n16 >> 4;
            }
        }
        this.reset();
    }

    public final void createWall(int n, int n2) {
        int n3 = RM.getWidth(this.mWallTexture);
        int n4 = RM.getHeight(this.mWallTexture);
        int[] nArray = RM.getInts(this.mWallTexture);
        int[] nArray2 = this.mField;
        int n5 = this.logicalToDirtFieldX(n);
        int n6 = this.logicalToDirtFieldX(n2);
        int n7 = Math.max(0, n5 - n6 / 2);
        int n8 = Math.min(this.mPixelWidth - 1, n5 + n6 / 2);
        int n9 = this.mPixelHeight - 1;
        for (int i = n7; i <= n8; ++i) {
            for (int j = n9; j >= 0; --j) {
                int n10 = j * this.mPixelWidth + i;
                if ((nArray2[n10] & 0xFF000000) != 0) continue;
                int n11 = i % n3 + j % n4 * n3;
                nArray2[n10] = 0xFF000000 | nArray[n11];
                this.mCachedHeights[i] = (short)n9;
            }
        }
    }

    public final void destroyCircle(int n, int n2, int n3, int n4) {
        int[] nArray = this.mField;
        DirtFieldBase.checkForFallingTanks(n, n3);
        int n5 = this.logicalToDirtFieldX(n);
        int n6 = this.logicalToDirtFieldY(n2);
        int n7 = this.logicalToDirtFieldX(n3);
        int n8 = this.logicalToDirtFieldX(n3 + n4);
        int n9 = Math.max(0, n5 - n8);
        int n10 = Math.min(this.mPixelWidth - 1, n5 + n8);
        int n11 = Math.max(0, n6 - n8);
        int n12 = Math.min(this.mPixelHeight - 1, n6 + n8);
        int n13 = n12 * this.mPixelWidth + n9;
        for (int i = n9; i <= n10; ++i) {
            boolean bl = false;
            int n14 = n13;
            for (int j = n12; j >= n11; --j) {
                block8: {
                    int n15;
                    block9: {
                        int n16;
                        int[] nArray2;
                        int n17;
                        block7: {
                            int n18 = i - n5;
                            int n19 = j - n6;
                            n17 = GCanvas.sqrt(n18 * n18 + n19 * n19 << 10) >> 10;
                            if (n17 >= n7) break block7;
                            if (!bl) {
                                bl = true;
                                this.mScanHeight[i] = (short)Math.max(this.mScanHeight[i], j);
                            }
                            if ((nArray[n14] & 0xFF000000) == 0) break block8;
                            nArray2 = nArray;
                            n16 = n14;
                            n15 = 0;
                            break block9;
                        }
                        if (n17 >= n8) break block8;
                        if (!bl) {
                            bl = true;
                            this.mScanHeight[i] = (short)Math.max(this.mScanHeight[i], j);
                        }
                        if ((nArray[n14] & 0xFF000000) == 0) break block8;
                        nArray2 = nArray;
                        n16 = n14;
                        n15 = nArray[n14] & 0xFF000000 | (nArray[n14] & 0xFEFEFE) >> 1;
                    }
                    nArray2[n16] = n15;
                }
                n14 -= this.mPixelWidth;
            }
            ++n13;
        }
    }

    public final int getGroundLevelForColumn(int n) {
        int[] nArray = this.mField;
        if (n < 0 || n >= this.mPixelWidth) {
            return 0;
        }
        int n2 = (this.mPixelHeight - 1) * this.mPixelWidth + n;
        int n3 = this.mPixelWidth;
        int n4 = this.mPixelHeight - 1;
        while (n4 >= 0) {
            if ((nArray[n2] & 0xFF000000) == 0) {
                return n4 + 1;
            }
            --n4;
            n2 -= n3;
        }
        return 0;
    }

    public final boolean isReady() {
        for (int i = 0; i < this.mPixelWidth; ++i) {
            if (this.mScanHeight[i] == -1) continue;
            return false;
        }
        return true;
    }

    public final boolean isSolid(int n, int n2) {
        int n3 = this.logicalToDirtFieldX(n);
        int n4 = this.logicalToDirtFieldY(n2);
        if (n4 < 0) {
            return false;
        }
        if (n4 >= this.mPixelHeight) {
            return true;
        }
        if (n3 < 0 || n3 >= this.mPixelWidth) {
            return false;
        }
        return (this.mField[n4 * this.mPixelWidth + n3] & 0xFF000000) != 0;
    }

    public final void render(Graphics graphics) {
        int n = this.mViewX;
        int n2 = this.mViewY;
        int n3 = 0;
        int n4 = 0;
        DirtFieldBase.getClampedCoordX(n, Game.instance.viewportGetWidth(), this.mPixelWidth, this.mOut);
        n = this.mOut[0];
        n3 = this.mOut[1];
        this.getClampedCoordY(n2, Game.instance.viewportGetHeight(), this.mPixelHeight, this.mOut);
        n2 = this.mOut[0];
        n4 = this.mOut[1];
        int n5 = Game.instance.viewportGetLeft();
        int n6 = Game.instance.viewportGetTop();
        graphics.drawRGB(this.mField, n2 * this.mPixelWidth + n, this.mPixelWidth, n5, n6, n3, n4, true);
    }

    public final boolean update() {
        int[] nArray = this.mField;
        boolean bl = false;
        for (int i = 0; i < this.mPixelWidth; ++i) {
            boolean bl2 = false;
            boolean bl3 = false;
            int n = this.mPixelHeight;
            int n2 = -1;
            int n3 = Math.min(this.mScanHeight[i], this.mPixelHeight - 1);
            int n4 = n3 * this.mPixelWidth + i;
            int n5 = this.mPixelWidth;
            for (int j = n3; j >= 0; --j) {
                boolean bl4 = (nArray[n4] & 0xFF000000) == 0;
                if (!bl4 && bl2) {
                    nArray[n4 + n5] = nArray[n4];
                    nArray[n4] = 0;
                    n = Math.min(n, j);
                    n2 = Math.max(n2, j + 1);
                    bl3 |= true;
                } else {
                    if (bl4 && !bl2 && (j == this.mPixelHeight - 1 || (nArray[n4 + n5] & 0xFF000000) != 0)) {
                        this.mCachedHeights[i] = (short)j;
                        bl = true;
                    }
                    bl2 = bl4;
                }
                n4 -= n5;
            }
            if (!bl3) {
                this.mScanHeight[i] = -1;
            }
            bl |= bl3;
        }
        return bl;
    }

    private void clear() {
        int[] nArray = this.mField;
        for (int i = 0; i < this.mPixelHeight * this.mPixelWidth; ++i) {
            nArray[i] = 0;
        }
    }
}

