/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class DashMenuItem {
    private Vector m_options = new Vector(2, 1);
    public DashImage m_icons;
    String m_name;
    int currOption = 0;
    private DashFont m_font;
    private int m_width;
    private int m_height;
    public int m_place;
    public int m_score;
    public boolean m_twoLineLeaderboard;

    public DashMenuItem(String name, int id, int width, DashFont font) {
        this.init(name, id, width, font);
    }

    public DashMenuItem(String name, int id, int width, DashFont font, int place, int score) {
        this.m_twoLineLeaderboard = true;
        this.m_place = place;
        this.m_score = score;
        String tmpName = place + " " + name;
        this.init(tmpName, -1, id, width, font);
        this.m_height *= 2;
    }

    public void staticInit() {
        this.m_options = new Vector();
        this.m_icons = null;
        this.currOption = 0;
    }

    private void init(String name, int id, int width, DashFont font) {
        this.staticInit();
        this.m_name = name;
        this.m_width = width;
        this.m_font = font;
        DashScrollableText newOption = new DashScrollableText(name, this.m_width, this.m_font);
        this.m_height = newOption.getHeight();
        this.m_options.addElement(new SubOption(newOption, id));
    }

    public void init(String name, int iconImg, int id, int width, DashFont font) {
        this.staticInit();
        this.m_name = name;
        this.m_width = width;
        this.m_font = font;
        if (iconImg != -1) {
            this.m_icons = DashResourceProvider.getImage(iconImg);
        }
        DashScrollableText newOption = new DashScrollableText(name, this.m_width, this.m_font);
        this.m_height = newOption.getHeight();
        this.m_options.addElement(new SubOption(newOption, id, -1));
    }

    public void setSelected(int s) {
        if (++s < 1 || s >= this.m_options.size()) {
            return;
        }
        this.currOption = s;
    }

    public void addOption(String opt, int id) {
        int w = this.m_width;
        DashScrollableText newOption = new DashScrollableText(opt, w, this.m_font);
        int headerH = ((SubOption)this.m_options.elementAt((int)0)).m_dst.getHeight();
        this.m_height = Math.max(this.m_height, newOption.getHeight() + headerH);
        if (this.m_options.size() == 1) {
            this.currOption = 1;
        }
        this.m_options.addElement(new SubOption(newOption, id));
    }

    public int HandleAction(int key) {
        switch (key) {
            case 2: {
                if (!this.hasOptions()) break;
                --this.currOption;
                if (this.currOption < 1) {
                    this.currOption = this.m_options.size() - 1;
                }
                return this.getCurrOptionID();
            }
            case 3: {
                if (!this.hasOptions()) break;
                ++this.currOption;
                if (this.currOption == this.m_options.size()) {
                    this.currOption = 1;
                }
                return this.getCurrOptionID();
            }
            case 4: 
            case 12: {
                if (this.hasOptions()) {
                    ++this.currOption;
                    if (this.currOption == this.m_options.size()) {
                        this.currOption = 1;
                    }
                }
                return this.getCurrOptionID();
            }
        }
        return -1;
    }

    public int getCurrOptionID() {
        return ((SubOption)this.m_options.elementAt((int)this.currOption)).m_ID;
    }

    public boolean hasOptions() {
        return this.m_options.size() > 1;
    }

    public void draw(Graphics g, int xoff, int yoff, int align) {
        SubOption titleItem = (SubOption)this.m_options.elementAt(0);
        titleItem.m_dst.draw(g, xoff, yoff, align);
        yoff += titleItem.m_dst.getHeight();
        SubOption currentItem = (SubOption)this.m_options.elementAt(this.currOption);
        if (this.hasOptions()) {
            currentItem.m_dst.draw(g, xoff, yoff, align);
        }
    }

    void drawSimple(Graphics g, int xoff, int yoff, int align, DashFont font) {
        if (font == null) {
            return;
        }
        font.drawString(g, this.m_name, xoff, yoff, align);
        font.drawString(g, this.m_name, xoff, yoff, align);
        if (this.m_twoLineLeaderboard) {
            font.drawString(g, "" + this.m_score, DashResourceProvider.getScreenWidth(), yoff + font.getHeight(), 24);
        }
    }

    public int getHeight() {
        return this.m_height;
    }

    private class SubOption {
        DashScrollableText m_dst;
        int m_ID;
        int m_iconIndex;

        SubOption(DashScrollableText dst, int id, int frame) {
            this.m_dst = dst;
            this.m_ID = id;
            this.m_iconIndex = frame;
        }

        SubOption(DashScrollableText dst, int id) {
            this.m_dst = dst;
            this.m_ID = id;
            this.m_iconIndex = 0;
        }
    }
}

