/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class FS {
    protected static final int METATYPE_INT = 0;
    protected static final int METATYPE_STRING = 1;
    protected static final int METATYPE_INT_ARRAY = 2;
    protected static final int METATYPE_CLASS_IMAGESLICE = 3;
    protected static final int METATYPE_CLASS_ANIMATION = 4;
    protected static final int FSNT_VOID = 0;
    protected static final int FSNT_DATA = 1;
    protected static final int FSNT_IMAGE = 2;
    protected static final int FSNT_SOUND = 3;
    protected static final int FSNT_FONT = 4;
    protected static final int FSNT_STRING = 5;
    protected static final int FSNT_STRARRAY = 6;
    protected static long pixelsLoaded = 0L;
    private static Class m_class = null;
    public static int[] crcTable = new int[256];
    protected static FSNode[] fileTable;
    protected static long m_accessTick;
    protected static boolean imageHeapIsSeparate;
    protected static boolean dontJitImages;
    protected static boolean usesConsecutiveIDs;
    private static final int PAGES_PER_FILE = 15;
    private static final String RMS_BASE_FILE = "rmsrr";
    public static Vector m_paletteSwapRequests;

    private static Class get_class() {
        if (m_class == null) {
            try {
                m_class = Class.forName("javax.microedition.midlet.MIDlet");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return m_class;
    }

    protected FS() {
    }

    protected static FSNode findFile(int fileID) {
        if (fileTable == null) {
            return null;
        }
        if (usesConsecutiveIDs) {
            if (fileID < 0 || fileID > fileTable.length) {
                return null;
            }
            return fileTable[fileID];
        }
        int low = 0;
        int hi = fileTable.length;
        while (hi > low + 1) {
            int i = (low + hi) / 2;
            int cmp = FS.fileTable[i].id - fileID;
            if (cmp == 0) {
                hi = low = i;
                continue;
            }
            if (cmp > 0) {
                hi = i;
                continue;
            }
            low = i + 1;
        }
        if (low >= fileTable.length || FS.fileTable[low].id != fileID) {
            return null;
        }
        return fileTable[low];
    }

    protected static void createTable(int count) {
        fileTable = new FSNode[count];
        for (int i = 0; i < count; ++i) {
            FS.fileTable[i] = new FSNode();
        }
    }

    protected static Image getImageRaw(int fileID) {
        FSNode file = FS.findFile(fileID);
        if (file == null) {
            throw new RuntimeException("Unable to load sp image " + fileID);
        }
        file.accessTick = m_accessTick++;
        if (file.rawObject != null) {
            return (Image)file.rawObject;
        }
        try {
            Image img = null;
            if (m_paletteSwapRequests.size() > 0) {
                Vector<colorPair> bv_cs = new Vector<colorPair>();
                for (int s = 0; s < m_paletteSwapRequests.size(); ++s) {
                    colorPair swapReq = (colorPair)m_paletteSwapRequests.elementAt(s);
                    if (swapReq.resID != fileID) continue;
                    bv_cs.addElement(swapReq);
                }
                if (bv_cs.size() > 0) {
                    colorPair[] csArr = new colorPair[bv_cs.size()];
                    for (int l = 0; l < bv_cs.size(); ++l) {
                        csArr[l] = (colorPair)bv_cs.elementAt(l);
                    }
                    img = FS.paletteSwap(csArr, "/" + fileID);
                } else {
                    img = Image.createImage((String)("/" + fileID));
                }
            } else {
                img = Image.createImage((String)("/" + fileID));
            }
            file.rawObject = img;
            pixelsLoaded += (long)(img.getWidth() * img.getHeight());
        }
        catch (Throwable s) {
            return FS.retryImage(fileID);
        }
        return (Image)file.rawObject;
    }

    private static Image retryImage(int fileID) {
        if (FS.dumpOldest() > 0) {
            for (int i = 0; i < 12; ++i) {
                FS.dumpOldest();
            }
            System.gc();
            return FS.getImageRaw(fileID);
        }
        throw new RuntimeException("out of memory loading file " + fileID);
    }

    private static int dumpOldest() {
        int target_id = -1;
        long target_tick = m_accessTick;
        for (int i = 0; i < fileTable.length; ++i) {
            if (!FS.fileTable[i].recyclable || FS.fileTable[i].rawObject == null && FS.fileTable[i].data == null || target_tick <= FS.fileTable[i].accessTick) continue;
            target_tick = FS.fileTable[i].accessTick;
            target_id = i;
        }
        if (target_id > -1) {
            if (FS.fileTable[target_id].rawObject instanceof Image) {
                Image img = (Image)FS.fileTable[target_id].rawObject;
                pixelsLoaded -= (long)(img.getWidth() * img.getHeight());
            }
            FS.fileTable[target_id].rawObject = null;
            FS.fileTable[target_id].data = null;
            return 1;
        }
        return 0;
    }

    protected static Animation getAnimation(int fileID) {
        FSNode file = FS.findFile(fileID);
        if (file == null) {
            return null;
        }
        if (file.meta == null) {
            return null;
        }
        for (int i = 0; i < file.meta.length; ++i) {
            if (!(file.meta[i] instanceof Animation)) continue;
            return (Animation)file.meta[i];
        }
        return null;
    }

    protected static ImageSlice getImageSlice(int fileID) {
        FSNode file = FS.findFile(fileID);
        if (file == null) {
            return null;
        }
        if (file.meta == null) {
            return null;
        }
        for (int i = 0; i < file.meta.length; ++i) {
            if (!(file.meta[i] instanceof ImageSlice)) continue;
            return (ImageSlice)file.meta[i];
        }
        return null;
    }

    protected static Object getMeta(int fileID, int metaIndex) {
        FSNode file = FS.findFile(fileID);
        if (file == null) {
            return null;
        }
        if (file.meta == null) {
            return null;
        }
        if (metaIndex >= file.meta.length) {
            return null;
        }
        return file.meta[metaIndex];
    }

    protected static void loadFS(String headerFile) throws IOException {
        DataInputStream in = new DataInputStream(FS.get_class().getResourceAsStream(headerFile));
        int size = in.readInt();
        int count = in.readInt();
        int validbytes = in.readInt();
        int metadataSize = in.readInt();
        pixelsLoaded = 0L;
        FS.createTable(count);
        for (int i = 0; i < count; ++i) {
            FS.fileTable[i].id = in.readInt();
            FS.fileTable[i].offset = in.readInt();
            FS.fileTable[i].length = in.readInt();
            FS.fileTable[i].unused = in.readInt();
            FS.fileTable[i].data = null;
            FS.fileTable[i].rawObject = null;
            FS.fileTable[i].dashObject = null;
            FS.fileTable[i].meta = null;
            if (FS.fileTable[i].id == i) continue;
            usesConsecutiveIDs = false;
        }
        while (metadataSize > 0) {
            int id = in.readInt();
            metadataSize -= 4;
            int numEntries = in.readInt();
            metadataSize -= 4;
            FSNode file = FS.findFile(id);
            file.meta = new Object[numEntries];
            block9: for (int i = 0; i < numEntries; ++i) {
                int type = in.readInt();
                metadataSize -= 4;
                switch (type) {
                    case 0: {
                        file.meta[i] = new Integer(in.readInt());
                        metadataSize -= 4;
                        continue block9;
                    }
                    case 1: {
                        file.meta[i] = FS.readString(in);
                        metadataSize -= ((String)FS.fileTable[id].meta[i]).length() + 1;
                        continue block9;
                    }
                    case 2: {
                        int arr_size = in.readInt();
                        metadataSize -= 4;
                        file.meta[i] = new int[arr_size];
                        for (int j = 0; j < arr_size; ++j) {
                            ((int[])file.meta[i])[j] = in.readInt();
                            metadataSize -= 4;
                        }
                        continue block9;
                    }
                    case 4: {
                        int j;
                        int arr_size = in.readInt();
                        metadataSize -= 4;
                        int[] temp = new int[arr_size];
                        for (j = 0; j < arr_size; ++j) {
                            temp[j] = in.readInt();
                            metadataSize -= 4;
                        }
                        file.meta[i] = new Animation(temp);
                        continue block9;
                    }
                    case 3: {
                        int j;
                        int arr_size = in.readInt();
                        metadataSize -= 4;
                        int[] temp = new int[arr_size];
                        for (j = 0; j < arr_size; ++j) {
                            temp[j] = in.readInt();
                            metadataSize -= 4;
                        }
                        file.meta[i] = new ImageSlice(temp);
                    }
                }
            }
        }
        in.close();
    }

    protected static byte[] getFile(String filename) {
        ByteArrayOutputStream baos = null;
        baos = new ByteArrayOutputStream();
        DataInputStream dis = new DataInputStream(FS.get_class().getResourceAsStream(filename));
        if (dis == null) {
            return null;
        }
        byte[] tempdata = new byte[256];
        try {
            int bytesread = dis.read(tempdata);
            while (bytesread > 0) {
                baos.write(tempdata, 0, bytesread);
                bytesread = dis.read(tempdata);
            }
        }
        catch (Exception e) {
            try {
                dis.close();
                return baos.toByteArray();
            }
            catch (Exception e2) {
                return null;
            }
        }
        dis = null;
        return baos.toByteArray();
    }

    protected static String readString(DataInputStream in) {
        String retval = "";
        try {
            int ch;
            while ((ch = in.read()) != 0) {
                retval = retval + (char)ch;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    public static boolean unloadResource(int fileID) {
        FSNode file = FS.findFile(fileID);
        if (file == null) {
            return false;
        }
        boolean retval = file.data != null || file.rawObject != null || file.dashObject != null;
        file.data = null;
        file.rawObject = null;
        file.dashObject = null;
        file.type = 0;
        return retval;
    }

    public static void setRecyclable(int fileID, boolean recyclable) {
        FSNode file = FS.findFile(fileID);
        if (file == null) {
            return;
        }
        file.recyclable = recyclable;
    }

    protected static int writeRMS(int id, byte[] data) {
        try {
            FS.setRecord(id, data, 0, data.length);
            return data.length;
        }
        catch (Exception e) {
            DashError.setError("error writing rms " + id + ", " + e);
            return -1;
        }
    }

    protected static byte[] readRMS(int id) {
        try {
            return FS.getRecord(id);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static boolean checkRecord(int page) {
        int file = page / 15;
        int record = page % 15;
        ++record;
        RecordStore rs = FS.openRS(file);
        int size = -1;
        try {
            size = rs.getRecordSize(record);
            rs.closeRecordStore();
        }
        catch (Exception e) {
            try {
                rs.closeRecordStore();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return size > -1;
    }

    private static void setRecord(int page, byte[] data, int offset, int length) throws Exception {
        int file = page / 15;
        int record = page % 15;
        RecordStore rs = FS.openRS(file);
        if (++record >= rs.getNextRecordID()) {
            FS.writeEmpty(record, rs);
        }
        try {
            rs.setRecord(record, data, offset, length);
            rs.closeRecordStore();
        }
        catch (Exception e) {
            try {
                rs.closeRecordStore();
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw e;
        }
    }

    private static void writeEmpty(int key, RecordStore rs) throws RecordStoreException {
        byte[] data = null;
        int curr = rs.getNextRecordID();
        int id = 0;
        while (key >= curr++) {
            if (data == null) {
                data = new byte[1];
            }
            id = rs.addRecord(data, 0, data.length);
        }
    }

    private static RecordStore openRS(int fileNum) {
        RecordStore retval = null;
        String storeName = RMS_BASE_FILE + fileNum;
        try {
            retval = RecordStore.openRecordStore((String)storeName, (boolean)true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    private static byte[] getRecord(int page) throws Exception {
        int file = page / 15;
        int record = page % 15;
        ++record;
        RecordStore rs = FS.openRS(file);
        byte[] retval = null;
        try {
            retval = rs.getRecord(record);
            rs.closeRecordStore();
        }
        catch (Exception e) {
            try {
                rs.closeRecordStore();
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw e;
        }
        return retval;
    }

    public static void deleteRecord(int page) {
        int file = page / 15;
        int record = page % 15;
        ++record;
        RecordStore rs = FS.openRS(file);
        try {
            rs.deleteRecord(record);
            rs.closeRecordStore();
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    public static void killPaletteSwaps(int resID) {
        for (int i = 0; i < m_paletteSwapRequests.size(); ++i) {
            colorPair currPair = (colorPair)m_paletteSwapRequests.elementAt(i);
            if (currPair.resID != resID) continue;
            m_paletteSwapRequests.removeElementAt(i);
            --i;
        }
        FS.unloadResource(resID);
    }

    public static void requestPaletteSwap(int resID, int colorFrom, int colorTo) {
        for (int i = 0; i < m_paletteSwapRequests.size(); ++i) {
            colorPair currPair = (colorPair)m_paletteSwapRequests.elementAt(i);
            if (currPair.from == colorFrom && currPair.resID == resID) {
                m_paletteSwapRequests.removeElementAt(i);
                --i;
            }
            if (currPair.from != colorTo || currPair.to != colorFrom || currPair.resID != resID) continue;
            m_paletteSwapRequests.removeElementAt(i);
            --i;
            FS.unloadResource(resID);
            return;
        }
        colorPair cp = new colorPair(resID, colorFrom, colorTo);
        m_paletteSwapRequests.addElement(cp);
        FS.unloadResource(resID);
    }

    public static int unsignByte(byte b) {
        if (b < 0) {
            return 256 + b;
        }
        return b;
    }

    public static Image paletteSwap(colorPair[] palette, String fileName) {
        try {
            byte[] imgBytes = FS.getFile(fileName);
            int palChunkLen = 0;
            int index = 8;
            int baseBufPalIndex = -1;
            while (true) {
                index += 2;
                int chunkLen = ((imgBytes[index++] & 0xFF) << 8) + (imgBytes[index++] & 0xFF);
                if (imgBytes[index] == 80 && imgBytes[index + 1] == 76 && imgBytes[index + 2] == 84 && imgBytes[index + 3] == 69) {
                    palChunkLen = chunkLen;
                    for (int i = baseBufPalIndex = index + 4; i < baseBufPalIndex + palChunkLen * 3; i += 3) {
                        int colorRGB = (FS.unsignByte(imgBytes[i]) << 16) + (FS.unsignByte(imgBytes[i + 1]) << 8) + FS.unsignByte(imgBytes[i + 2]);
                        for (int j = 0; j < palette.length; ++j) {
                            if (colorRGB != palette[j].from) continue;
                            imgBytes[i] = (byte)(palette[j].to >> 16);
                            imgBytes[i + 1] = (byte)(palette[j].to >> 8 & 0xFF);
                            imgBytes[i + 2] = (byte)(palette[j].to & 0xFF);
                        }
                    }
                } else if (imgBytes[index] == 73 && imgBytes[index + 1] == 69 && imgBytes[index + 2] == 78 && imgBytes[index + 3] == 68) {
                    if (baseBufPalIndex >= 0) break;
                    return Image.createImage((String)fileName);
                }
                index += chunkLen + 8;
            }
            palChunkLen += 4;
            baseBufPalIndex -= 4;
            int crc = -1;
            int i = 0;
            while (i < palChunkLen) {
                crc = crcTable[(crc ^ imgBytes[baseBufPalIndex]) & 0xFF] ^ crc >>> 8;
                ++i;
                ++baseBufPalIndex;
            }
            imgBytes[baseBufPalIndex++] = (byte)((crc ^= 0xFFFFFFFF) >>> 24);
            imgBytes[baseBufPalIndex++] = (byte)(crc >>> 16);
            imgBytes[baseBufPalIndex++] = (byte)(crc >>> 8);
            imgBytes[baseBufPalIndex] = (byte)crc;
            Image image = Image.createImage((byte[])imgBytes, (int)0, (int)imgBytes.length);
            return image;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                Image temp = Image.createImage((String)fileName);
                return temp;
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int c = i;
            for (int j = 0; j < 8; ++j) {
                if ((c & 1) != 0) {
                    c = c >>> 1 ^ 0xEDB88320;
                    continue;
                }
                c >>>= 1;
            }
            FS.crcTable[i] = c;
        }
        fileTable = null;
        m_accessTick = 0L;
        usesConsecutiveIDs = true;
        m_paletteSwapRequests = new Vector();
    }

    protected static class FSNode {
        int id = -1;
        int offset;
        int length;
        int unused;
        int type = 0;
        long accessTick = 0L;
        boolean recyclable = true;
        byte[] data = null;
        Object rawObject = null;
        Object dashObject = null;
        Object[] meta = null;

        protected FSNode() {
        }
    }
}

