/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class MagicColorBox {
    boolean finished;
    int m_rows;
    int m_columns;
    int m_rowW;
    int m_columnH;
    int m_type;
    long m_cycleTimeMS;
    AEERect m_area;
    int m_colorStart;
    int m_colorEnd;
    Vector m_boxes = new Vector();
    AEERect[] m_boxesIn;
    int m_boxesInSize;
    byte m_doNotDraw;

    void update() {
        for (int i = 0; i < this.m_boxes.size(); ++i) {
            cBox currBox = (cBox)this.m_boxes.elementAt(i);
            if (currBox.startTime > DashResourceProvider.getAppTime()) continue;
            currBox.currColor = DashResourceProvider.interpolateColors(currBox.colorStart, currBox.colorEnd, currBox.startTime, DashResourceProvider.getAppTime(), currBox.endTime);
            if (this.m_type == 0 || this.m_type == 2 || this.m_type == 1) {
                if (DashResourceProvider.getAppTime() <= currBox.endTime) continue;
                if (this.m_doNotDraw == 1) {
                    currBox.doNotDraw = DashResourceProvider.getRand(0, 1) == 1;
                }
                currBox.startTime = DashResourceProvider.getAppTime();
                currBox.endTime = DashResourceProvider.getAppTime() + this.m_cycleTimeMS;
                int oldStart = currBox.colorStart;
                if (this.m_type == 1) {
                    oldStart = DashResourceProvider.getRand(0, 0xFFFFFF);
                }
                currBox.colorStart = currBox.colorEnd;
                currBox.colorEnd = oldStart;
                continue;
            }
            if (this.m_type == 3) {
                if (i != this.m_boxes.size() - 1) continue;
                int boxSize = this.m_boxes.size();
                Vector<cBox> tempBoxes = new Vector<cBox>();
                for (int dush = 0; dush < this.m_boxes.size(); ++dush) {
                    cBox oldBox = (cBox)this.m_boxes.elementAt(dush);
                    cBox newBox = new cBox(oldBox.area, oldBox.startTime, oldBox.endTime, oldBox.colorStart, oldBox.colorEnd);
                    tempBoxes.addElement(newBox);
                }
                this.m_boxes.removeAllElements();
                long spectrumTimeOffset = 0L;
                for (int k = boxSize - 1; k >= 0; --k) {
                    cBox kBox = (cBox)tempBoxes.elementAt(k);
                    int oldStart = kBox.colorStart;
                    kBox.colorStart = kBox.colorEnd;
                    kBox.colorEnd = oldStart;
                    kBox.startTime = DashResourceProvider.getAppTime() + spectrumTimeOffset;
                    kBox.endTime = kBox.startTime + this.m_cycleTimeMS;
                    this.m_boxes.addElement(kBox);
                    spectrumTimeOffset += this.m_cycleTimeMS * 20L / 100L;
                }
                continue;
            }
            if (this.m_type != 4 || i != this.m_boxes.size() - 1 || currBox.currColor != currBox.colorEnd) continue;
            this.finished = true;
        }
    }

    void draw(Graphics g) {
        for (int i = 0; i < this.m_boxes.size(); ++i) {
            cBox currBox = (cBox)this.m_boxes.elementAt(i);
            if (currBox.doNotDraw) continue;
            DashEngine.fillRect(g, currBox.area.x, currBox.area.y, currBox.area.dx, currBox.area.dy, currBox.currColor);
        }
    }

    void draw(Graphics g, int offX, int offY) {
        for (int i = 0; i < this.m_boxes.size(); ++i) {
            cBox currBox = (cBox)this.m_boxes.elementAt(i);
            DashEngine.fillRect(g, currBox.area.x + offX, currBox.area.y + offY, currBox.area.dx, currBox.area.dy, currBox.currColor);
        }
    }

    void draw(Graphics g, int offX, int offY, int dx, int dy) {
        for (int i = 0; i < this.m_boxes.size(); ++i) {
            cBox currBox = (cBox)this.m_boxes.elementAt(i);
            DashEngine.fillRect(g, currBox.area.x + offX, currBox.area.y + offY, dx, dy, currBox.currColor);
        }
    }

    cBox initColor(AEERect boxArea, long spectrumTimeOffset) {
        long sTime = DashResourceProvider.getAppTime();
        int cs = this.m_colorStart;
        int ce = this.m_colorEnd;
        if (this.m_type == 0 || this.m_type == 1) {
            cs = DashResourceProvider.getRand(0, 0xFFFFFF);
            ce = DashResourceProvider.getRand(0, 0xFFFFFF);
        } else if (this.m_type == 2) {
            int csFlat = 0;
            csFlat = DashResourceProvider.getRand(0, 1);
            if (csFlat != 0) {
                cs = DashResourceProvider.getRand(0, 1) == 1 ? this.m_colorStart : this.m_colorEnd;
                ce = DashResourceProvider.interpolateColors(this.m_colorStart, this.m_colorEnd, 0L, DashResourceProvider.getRand(0, 100), 100L);
            } else {
                ce = DashResourceProvider.getRand(0, 1) == 1 ? this.m_colorStart : this.m_colorEnd;
                cs = DashResourceProvider.interpolateColors(this.m_colorStart, this.m_colorEnd, 0L, DashResourceProvider.getRand(0, 100), 100L);
            }
        } else if (this.m_type == 3 || this.m_type == 4) {
            sTime = DashResourceProvider.getAppTime() + spectrumTimeOffset;
            spectrumTimeOffset += this.m_cycleTimeMS * 20L / 100L;
        }
        cBox c = new cBox(boxArea, sTime, sTime + this.m_cycleTimeMS, cs, ce);
        return c;
    }

    void updateAnimCycle(long newCycle) {
        this.m_cycleTimeMS = newCycle;
    }

    public MagicColorBox(byte type, AEERect area, int rows, int columns, long cycleSpeedMS, int colorStart, int colorEnd, AEERect[] boxesIn, int boxesInSize, byte doNotDraw) {
        this.m_boxesIn = boxesIn;
        this.m_boxesInSize = boxesInSize;
        this.m_doNotDraw = doNotDraw;
        this.finished = false;
        this.m_type = type;
        this.m_rows = rows;
        this.m_columns = columns;
        this.m_area = area;
        this.m_cycleTimeMS = cycleSpeedMS;
        this.m_colorStart = colorStart;
        this.m_colorEnd = colorEnd;
        int remainderW = 0;
        int remainderH = 0;
        if (this.m_boxesIn == null) {
            this.m_rowW = this.m_area.dx / this.m_columns;
            remainderW = this.m_area.dx % this.m_columns;
            this.m_columnH = this.m_area.dy / this.m_rows;
            remainderH = this.m_area.dy % this.m_rows;
            if (this.m_columns > this.m_area.dx) {
                this.m_rows = 1;
                remainderW = 0;
            }
            if (this.m_rows > this.m_area.dy) {
                this.m_columns = 1;
                remainderH = 0;
            }
        }
        int rowOffsetX = this.m_area.x;
        int columnOffsetY = this.m_area.y;
        long spectrumTimeOffset = 0L;
        if (this.m_boxesIn == null) {
            for (int r = 0; r < this.m_rows; ++r) {
                for (int c = 0; c < this.m_columns; ++c) {
                    int Hoffset = 0;
                    int Woffset = 0;
                    if (r == this.m_rows - 1) {
                        Hoffset = remainderH;
                    }
                    if (c == this.m_columns - 1) {
                        Woffset = remainderW;
                    }
                    AEERect boxArea = new AEERect(rowOffsetX, columnOffsetY, this.m_rowW + Woffset, this.m_columnH + Hoffset);
                    cBox cb = this.initColor(boxArea, spectrumTimeOffset);
                    this.m_boxes.addElement(cb);
                    rowOffsetX += this.m_rowW;
                }
                rowOffsetX = this.m_area.x;
                columnOffsetY += this.m_columnH;
            }
        } else {
            for (int j = 0; j < this.m_boxesInSize; ++j) {
                AEERect boxArea = new AEERect(this.m_boxesIn[j].x, this.m_boxesIn[j].y, this.m_boxesIn[j].dx, this.m_boxesIn[j].dy);
                cBox cb = this.initColor(boxArea, spectrumTimeOffset);
                this.m_boxes.addElement(cb);
            }
        }
        if (this.m_doNotDraw == 2) {
            boolean drawYoN = true;
            int prevY = ((cBox)this.m_boxes.elementAt((int)0)).area.y;
            for (int j = 0; j < this.m_boxes.size(); ++j) {
                cBox currBox = (cBox)this.m_boxes.elementAt(j);
                if (currBox.area.y != prevY) {
                    drawYoN = !drawYoN;
                }
                currBox.doNotDraw = !drawYoN;
                drawYoN = !drawYoN;
                prevY = currBox.area.y;
            }
        }
    }

    public MagicColorBox() {
    }

    private class cBox {
        AEERect area;
        int scale = 100;
        long startTime;
        long endTime;
        int colorStart;
        int currColor;
        int colorEnd;
        boolean doNotDraw;

        public cBox(AEERect inArea, long inStartTime, long inEndTime, int inColorStart, int inColorEnd) {
            this.startTime = inStartTime;
            this.endTime = inEndTime;
            this.colorStart = this.currColor = inColorStart;
            this.colorEnd = inColorEnd;
            this.area = inArea;
            this.doNotDraw = false;
        }
    }
}

